<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

class UserHandler {

    private $dao;
    private $grouperConfig;

    public function __construct(DAO $dao, $grouperConfig) {
        $this->dao = $dao;
        $this->grouperConfig = $grouperConfig;
    }

    public function saveUser(User $user) {

        $primarySpecified = true;

        // If new user
        if ($user->id === null) {
            $primarySpecified = false;
            $user->id = $this->dao->createUser();
        }

        foreach ($user->identities as $identity) {
            if ($identity->id === null) {
                $identity->id = $this->dao->insertIdentity($identity, $user->id);
                if (!$primarySpecified) {
                    $this->dao->setPrimaryIdentity($user->id, $identity->id);
                    $identity->primary = true;
                }
            }
        }
    }

    public function findUserByIdentity($type, $identifier) {

        return $this->dao->findUserByIdentity($type, $identifier);
    }

    public function joinUsers($userId1, $userId2) {

        if ($this->grouperConfig !== null) {
            $gc = new GrouperClient($this->grouperConfig);

            $groupsToMove = $gc->getSubjectGroups('RAP:' . $userId2);
            $gc->addMemberships('RAP:' . $userId1, $groupsToMove);
            $gc->removeMemberships('RAP:' . $userId2, $groupsToMove);
        }

        $this->dao->joinUsers($userId1, $userId2);
    }

}
