<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

$CONTEXT_ROOT = "/rap-ia2";
$VERSION = "1.0.0";

$PROTOCOL = stripos($_SERVER['SERVER_PROTOCOL'], 'https') ? 'https://' : 'http://';
$BASE_PATH = $PROTOCOL . $_SERVER['HTTP_HOST'] . $CONTEXT_ROOT;

$LOG_PATH = ROOT . "/logs/rap-service.log";
$LOG_LEVEL = Monolog\Logger::DEBUG;

$CALLBACKS = [
    array(
        'url' => 'http://localhost:8087/grouper',
        'title' => 'Login to Grouper'
    )
];

$DATABASE = array(
    'dbtype' => 'MySQL',
    'hostname' => 'localhost',
    'port' => 3306,
    'username' => 'rap',
    'password' => '***REMOVED***',
    'dbname' => 'rap'
);

$AUTHENTICATION_METHODS = array(
    'eduGAIN' => array(),
    'Google' => array(
        'id' => "***REMOVED***.apps.googleusercontent.com",
        'secret' => "***REMOVED***",
        'callback' => $BASE_PATH . "/auth/oauth2/google_token.php"),
    'Facebook' => array(
        'id' => "***REMOVED***",
        'secret' => "***REMOVED***",
        'version' => "v2.2",
        'callback' => $BASE_PATH . "/auth/oauth2/facebook_token.php"),
    'LinkedIn' => array(
        'id' => '***REMOVED***',
        'secret' => '***REMOVED***',
        'callback' => $BASE_PATH . '/auth/oauth2/linkedin_token.php'
    ),
    'X.509' => array(),
);

$GROUPER = array(
    'wsdlURL' => 'http://localhost:8087/grouper-ws/services/GrouperService_v2_3?wsdl',
    'user' => 'GrouperSystem',
    'password' => '***REMOVED***'
);
