<?php

namespace RAP;

interface AccessTokenDAO {

    /**
     * Store a new login token into the database.
     * @param type $token login token
     * @param type $userId
     */
    function createAccessToken(AccessToken $accessToken): AccessToken;

    function retrieveAccessTokenFromCode(string $code): ?AccessToken;

    function getAccessToken(string $token): ?AccessToken;

    function deleteAccessToken(string $token): void;
}
