<?php

namespace RAP;

class ShibbolethLogin extends LoginHandler {

    public function __construct(Locator $locator) {
        parent::__construct($locator, Identity::EDU_GAIN);
    }

    public function login() {

        $prefix = '';

        if (isset($_SERVER['Shib-Session-ID']) || $redirect = isset($_SERVER['REDIRECT_Shib-Session-ID'])) {

            if (isset($_SERVER['REDIRECT_Shib-Session-ID'])) {
                $prefix = 'REDIRECT_';
            }

            // Retrieving eduPersonPrincipalName (eppn)
            $eppn = $_SERVER[$prefix . 'eppn'];

            // Search if the user is already registered into RAP using the eppn.
            // The persistent id should be a more appropriate identifier, however at IA2
            // we need to import all INAF user into RAP, even if they will never register,
            // and in that case we know only their eppn.

            return $this->onIdentityDataReceived($eppn, function($identity) use($eppn, $prefix) {
                $identity->email = $_SERVER[$prefix . 'mail'];
                $identity->name = $_SERVER[$prefix . 'givenName'];
                $identity->surname = $_SERVER[$prefix . 'sn'];
                $identity->eppn = $eppn;
            });
        } else {
            http_response_code(500);
            die("Shib-Session-ID not found!");
        }
    }

}
