<?php

namespace RAP;

class AccessToken {

    private const TOKEN_LIFESPAN = 3600;

    public function __construct() {
        $this->creationTime = time();
        $this->expirationTime = $this->creationTime + AccessToken::TOKEN_LIFESPAN;
    }

    public $token;
    public $code;
    public $userId;
    public $creationTime;
    public $expirationTime;
    public $redirectUri;
    public $clientId;
    public $scope;

    public function isExpired(): bool {
        return $this->expirationTime < time();
    }

}
