<?php

namespace RAP;

class X509Login extends LoginHandler {

    private $x509Data;

    public function __construct(Locator $locator) {
        parent::__construct($locator, Identity::X509);
    }

    public function login(): string {
        if (isset($_SERVER['SSL_CLIENT_VERIFY']) && isset($_SERVER['SSL_CLIENT_V_REMAIN']) &&
                $_SERVER['SSL_CLIENT_VERIFY'] === 'SUCCESS' && $_SERVER['SSL_CLIENT_V_REMAIN'] > 0) {

            $x509Data = RAP\X509Data::parse($_SERVER);
            $this->x509Data = $x509Data;

            return $this->onIdentityDataReceived($x509Data->serialNumber, function($identity) use ($x509Data) {
                        $this->fillIdentity($identity, $x509Data);
                    });
        } else {
            http_response_code(500);
            die("Unable to verify client certificate");
        }

        return null;
    }

    public function afterNameSurnameSelection($x509Data) {
        $redirect = $this->onIdentityDataReceived($x509Data->serialNumber, function($identity) use ($x509Data) {
            $this->fillIdentity($identity, $x509Data);
        });

        $session = $this->locator->getSession();
        $session->setX509DataToRegister(null);

        return $redirect;
    }

    private function fillIdentity($identity, $x509Data) {
        $identity->email = $x509Data->email;
        $identity->name = $x509Data->name;
        $identity->surname = $x509Data->surname;
        $identity->institution = $x509Data->institution;
    }

    /**
     * We want to extract name and surname from the X.509 certificate, however X.509
     * puts name and surname together (inside the CN field).
     * If name and surname are single words it is possible to retrieve them splitting
     * on the space character, otherwise the user has to choose the correct combination.
     * In that case partial X.509 data is temporarily stored into the user session and
     * the page views/x509-name-surname.php is shown to the user before completing the
     * registration, in order to allow him/her selecting the correct name and surname.
     */
    protected function handleNewIdentity(string $typedId, \Closure $fillIdentityData): string {

        $session = $this->locator->getSession();

        if ($this->x509Data->name === null) {
            $session->setX509DataToRegister($this->x509Data);
            return $this->locator->getBasePath() . '/x509-name-surname';
        } else {
            return parent::handleNewIdentity($typedId, $fillIdentityData);
        }
    }

}
