(function () {

    var AUTH_METHODS = ['eduGAIN', 'Google', 'Facebook', 'LinkedIn', 'X.509', 'LocalIdP'];

    var vm = new Vue({
        el: '#admin-vue',
        data: {
            oauth2Clients: [],
            oauth2ClientToDelete: null
        },
        methods: {
            addNewOAuth2Client: function () {
                this.$data.oauth2Clients.push(getNewClient());
            },
            editOAuth2Client: function (client) {
                client.edit = true;
                vm.$forceUpdate();
            },
            getAuthMethodsString: function (authMethods) {
                var selectedValues = [];
                for (var i = 0; i < AUTH_METHODS.length; i++) {
                    var method = AUTH_METHODS[i];
                    if (authMethods[method] === true) {
                        selectedValues.push(method);
                    }
                }
                return selectedValues.join(', ');
            },
            saveOAuth2Client: function (client, index) {
                if (client.id === null) {
                    createOAuth2Client(client, index);
                } else {
                    updateOAuth2Client(client, index);
                }
            },
            askConfirmDeleteOAuth2Client: function (client, index) {
                vm.$data.oauth2ClientToDelete = index;
                if (client.id === null) {
                    deleteOAuth2Client();
                } else {
                    $('#client-to-delete').text(client.title);
                    $('#confirm-delete-client-modal').modal('show');
                }
            }
        }
    });

    function getNewClient() {
        var client = {
            id: null,
            title: null,
            icon: null,
            client: null,
            secret: null,
            redirectUrl: null,
            scope: null,
            authMethods: {},
            edit: true
        };
        for (var i = 0; i < AUTH_METHODS.length; i++) {
            client.authMethods[AUTH_METHODS[i]] = true;
        }
        return client;
    }

    /* Converts the model received from the server into a model
     * useful for the Vue manipulation */
    function getJsModel(client) {
        var jsAuthMethods = {};
        for (var i = 0; i < AUTH_METHODS.length; i++) {
            var method = AUTH_METHODS[i];
            jsAuthMethods[method] = client.authMethods.includes(method);
        }
        client.authMethods = jsAuthMethods;
        client.edit = false;
        return client;
    }

    /* Converts the model manipulated by Vue in the model expected by the back-end */
    function getBackendModel(client) {
        var client = Vue.util.extend({}, client);
        var authMethods = [];
        for (var i = 0; i < AUTH_METHODS.length; i++) {
            var method = AUTH_METHODS[i];
            if (client.authMethods[method] === true) {
                authMethods.push(method);
            }
        }
        client.authMethods = authMethods;
        delete client.edit;
        return client;
    }

    function createOAuth2Client(client, index) {
        showWaiting();
        $.ajax({
            url: 'admin/oauth2_clients',
            method: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(getBackendModel(client))
        }).then(function (data) {
            vm.$data.oauth2Clients[index] = getJsModel(data);
            vm.$forceUpdate();
            hideWaiting();
        });
    }

    function updateOAuth2Client(client, index) {
        showWaiting();
        $.ajax({
            url: 'admin/oauth2_clients',
            method: 'PUT',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(getBackendModel(client))
        }).then(function (data) {
            vm.$data.oauth2Clients[index] = getJsModel(data);
            vm.$forceUpdate();
            hideWaiting();
        });
    }


    function deleteOAuth2Client() {
        var client = vm.$data.oauth2Clients[vm.$data.oauth2ClientToDelete];
        if (client.id === null) {
            vm.$data.oauth2Clients.splice(vm.$data.oauth2ClientToDelete, 1);
            vm.$forceUpdate();
        } else {
            showWaiting();
            $.ajax({
                url: 'admin/oauth2_clients/' + client.id,
                method: 'DELETE'
            }).then(function () {
                vm.$data.oauth2Clients.splice(vm.$data.oauth2ClientToDelete, 1);
                $('#confirm-delete-client-modal').modal('hide');
                vm.$forceUpdate();
                hideWaiting();
            });
        }
    }
    $(document).on('click', '#confirm-delete-client', deleteOAuth2Client);

    showWaiting();

    $.ajax({
        url: 'admin/oauth2_clients',
        method: 'GET',
        dataType: 'json'
    }).then(function (data) {
        var clients = [];
        for (var i = 0; i < data.length; i++) {
            clients.push(getJsModel(data[i]));
        }
        vm.$data.oauth2Clients = clients;
        hideWaiting();
    });

})();