#!/bin/bash

# Exit on any error. More complex stuff could be done in future
# (see https://stackoverflow.com/questions/4381618/exit-a-script-on-error)
set -e


if [ "x$SAFE_MODE" == "xTrue" ]; then

    echo ""
    echo "[INFO] Not executing entrypoint as we are in safe mode, just opening a Bash shell."
    exec /bin/bash

else

    #---------------------
    #   Setup home
    #---------------------

    if [ ! -f "/home/metauser/.initialized" ]; then
        echo "[INFO] Setting up home"
        [ ! -d "/home/metauser" ] &&  mkdir -p /home/metauser
        # Copy over vanilla home contents
        for x in /metauser_home_vanilla/* /metauser_home_vanilla/.[!.]* /metauser_home_vanilla/..?*; do
            if [ -e "$x" ]; then cp -a "$x" /home/metauser/; fi
        done
	echo source $INSTALLDIR/init.sh >> $HOME/.bashrc
        # Mark as initialized
        [ ! -f "/home/metauser/.initialized" ] && touch /home/metauser/.initialized
    fi
    #---------------------
    #   Save env
    #---------------------
    echo "[INFO] Dumping env"

    # Save env vars for later usage (e.g. ssh)

    env | \
    while read env_var; do
      if [[ $env_var == HOME\=* ]]; then
          : # Skip HOME var
      elif [[ $env_var == PWD\=* ]]; then
          : # Skip PWD var
      else
          echo "export $env_var" >> /tmp/env.sh
      fi
    done

    echo ""
    echo "[INFO] Executing entrypoint..."

    if [ "xxx$@"  == "xxx" ]; then
        COMMAND="/bin/bash"
    else
            COMMAND="$@"
    fi


    # Start!
        echo -n "[INFO] Will execute entrypoint command: "
        echo $COMMAND
        echo ""
        echo "=============================================================="
        echo ""
        echo "      Welcome to the LOFAR  $CONTAINER_NAME container!"
        echo ""
        echo "=============================================================="
        echo ""
        echo "You are now in /home/metauser with write access as user \"$(whoami)\"."
        echo ""
        echo "Remember that contents inside this container, unless stored"
        echo "on a persistent volume mounted from you host machine, will"
        echo "be wiped out when exiting the container."
        echo ""
	echo "This image acts as a base for the LOFAR installationi."
	echo "It has Fedora 31 setup, with the required dependencies installed:"
	echo "    * Armadillo 9.900.3"
	echo "    * Boost 1.69.0"
	echo "    * Armadillo 9.900.3"
	echo "    * Boost 1.69.0"
	echo "    * CFITSIO 7.3.47"
	echo "    * FFTW 3.5.8"
	echo "    * HDF5 1.10.5"
	echo "    * LAPACK 3.8.0"
	echo "    * OpenBLAS 3.8.0"
	echo "    * SuperLU 5.2.1"
	echo "    * WCSLIB 6.4"
	echo "    * Armadillo 9.900.3"
	echo "    * Boost 1.69.0"
	echo "    * Armadillo 9.900.3"
	echo "    * Boost 1.69.0"
	echo "    * CFITSIO 7.3.47"
	echo "    * FFTW 3.5.8"
	echo "    * HDF5 1.10.5"
	echo "    * LAPACK 3.8.0"
	echo "    * OpenBLAS 3.8.0"
	echo "    * SuperLU 5.2.1"
	echo "    * WCSLIB 6.4"
        echo ""
        cd /home/metauser
        $COMMAND
fi

