#!/bin/bash

# Exit on any error. More complex stuff could be done in future
# (see https://stackoverflow.com/questions/4381618/exit-a-script-on-error)
set -e


if [ "x$SAFE_MODE" == "xTrue" ]; then

    echo ""
    echo "[INFO] Not executing entrypoint as we are in safe mode, just opening a Bash shell."
    exec /bin/bash

else

    echo ""
    echo "[INFO] Executing entrypoint..."
    
    if [ "x$GUI" == "xTrue" ]; then
        if [ "x$BASE_PORT" == "x" ]; then
            echo "[INFO] No task base port set, will set noVNC port 8590 and VNC port 5900 with desktop id \"0\""  
        else 
            echo "[INFO] Task base port set, will set noVNC port $BASE_PORT and noVNC port $(($BASE_PORT+1)) with desktop id \"$(($BASE_PORT-5900+1))\""
        fi
    fi
    
    #---------------------
    #   Setup home
    #---------------------

    if [ -f "/home/metauser/.initialized" ]; then
        :
    else
        echo "[INFO] Setting up home"
        mkdir -p /home/metauser

        # Copy over vanilla home contents
        for x in /metauser_home_vanilla/* /metauser_home_vanilla/.[!.]* /metauser_home_vanilla/..?*; do
            if [ -e "$x" ]; then cp -a "$x" /home/metauser/; fi
        done
        
        # Mark as initialized
        touch /home/metauser/.initialized
    fi
    

    #---------------------
    #   Save env
    #---------------------
    echo "[INFO] Dumping env"
    
    # Save env vars for later usage (e.g. ssh)
    
    env | \
    while read env_var; do
      if [[ $env_var == HOME\=* ]]; then
          : # Skip HOME var
      elif [[ $env_var == PWD\=* ]]; then
          : # Skip PWD var
      else
          echo "export $env_var" >> /tmp/env.sh
      fi
    done
    
    #---------------------
    #   VNC Password
    #---------------------
    if [ "x$GUI" == "xTrue" ]; then
        if [ "x$AUTH_PASS" != "x" ]; then
            echo "[INFO] Setting up VNC password..."
            mkdir -p /home/metauser/.vnc
            /opt/tigervnc/usr/bin/vncpasswd -f <<< $AUTH_PASS > /home/metauser/.vnc/passwd
            chmod 600 /home/metauser/.vnc/passwd
            export VNC_AUTH=True
        else
            echo "[INFO] Not setting up any VNC password"
                
        fi
    fi
    
    echo "[INFO] Creating /tmp/metauserhome to be used as metauser home"
    mkdir /tmp/metauserhome
    
    echo "[INFO] Initializing /tmp/metauserhome with configuration files"
    cp -aT /metauser_home_vanilla /tmp/metauserhome
    
    echo "[INFO] Moving to /home/metauser and setting as home"
    cd /home/metauser
    export HOME=/home/metauser
    
    echo "[INFO] Setting new prompt @$CONTAINER_NAME container"
    echo 'export PS1="${debian_chroot:+($debian_chroot)}\u@$CONTAINER_NAME@\h:\w\$ "' >> /tmp/metauserhome/.bashrc

    echo "[INFO] Sourcing env in /opt/lofar/init.sh..."
    source /opt/lofar/init.sh
          
    # Set entrypoint command
    if [ "x$@" == "x" ]; then
        COMMAND="/bin/bash"
    else
        COMMAND="$@"
    fi
    

    # Start!
    echo -n "[INFO] Will execute entrypoint command: "
    echo $COMMAND
    echo ""
    echo "=============================================================="
    echo ""
    echo "      Welcome to the LOFAR-IT $CONTAINER_NAME container!"
    echo ""
    echo "=============================================================="
    echo ""
    echo "You are now in /home/metauser with write access as user \"$(whoami)\"."
    echo ""
    echo "Remember that contents inside this container, unless stored"
    echo "on a persistent volume mounted from you host machine, will"
    echo "be wiped out when exiting the container."
    echo ""
    
    exec $COMMAND

fi
