#!/bin/bash
#
# This Script allows to execute the container using singularity
# in an isolated enviroment, home directory and tmp are not
# shared directly and removed at the end of the run, persistent data 
# is saved in /data 
#
# author <giuliano.taffoni@inaf.it>
#

export CONTAINER_NAME=git.ia2.inaf.it:5050/lofarit/containers/vlbi-inaf-sw
export CONTAINER_VERSION=0.1.0
export BASE_PORT=
if [ 'XXX'$1 = 'XXX' ]; then
    COMMAND=
else
    COMMAND=$1
fi

export SINGULARITYENV_AUTH_USER=testpass

HOMEDIR=`mktemp -d -t singularity_XXXXXXX`
mkdir $HOMEDIR/tmp
mkdir $HOMEDIR/home
singularity run  --pid --no-home --home=/home/skauser --workdir ${HOMEDIR}/tmp -B${HOMEDIR}:/home/ -B`pwd`:/data --containall --cleanenv docker://${CONTAINER_NAME}:${CONTAINER_VERSION} $COMMAND
rm -fr ${HOMEDIR}
