#!/bin/bash

# Exit on any error. More complex thing could be done in future
# (see https://stackoverflow.com/questions/4381618/exit-a-script-on-error)
set -e

echo ""
echo "[INFO] Executing entrypoint..."

#echo "[INFO] Sourcing env in /opt/lofarsoft/lofarinit.sh..."
source /opt/lofarsoft/lofarinit.sh

echo "[INFO] Creating /tmp/lofarhome to be used as lofar home"
mkdir /tmp/lofarhome

echo "[INFO] Initialising /tmp/lofarhome with configuration files"
cp -aT /home/vanilla_lofar /tmp/lofarhome

echo "[INFO] Moving to /home/lofar and setting as home"
cd /home/lofar
export HOME=/home/lofar

echo "[INFO] Setting new prompt @$CONTAINER_NAME container"
echo 'export PS1="${debian_chroot:+($debian_chroot)}\u@$CONTAINER_NAME@\h:\w\$ "' >> /tmp/lofarhome/.bashrc

# Set entrypoint command
if [ "x$@" == "x" ]; then
    COMMAND="/bin/bash"
else
    COMMAND="$@"
fi



# Start!
echo -n "[INFO] Will execute entrypoint command: "
echo $COMMAND
echo ""
echo "=============================================================="
echo ""
echo "      Welcome to the LOFAR-IT $CONTAINER_NAME container!"
echo ""
echo "=============================================================="
echo ""
echo "You are now in /home/lofar with write access as user \"$(whoami)\"."
echo ""
echo "Remember that contents inside this container, unless stored"
echo "on a persistent volume mounted from you host machine, will"
echo "be wiped out when exiting the container."
echo ""

exec $COMMAND

