#include <mpi.h>
#include <omp.h>
#include <stdio.h>
#include "../common/common.h"
#include "../tree/tree.h"

//

#ifdef THREAD_FUNNELED
    #define THREAD_LEVEL MPI_THREAD_FUNNELED
#else
    #define THREAD_LEVEL MPI_THREAD_MULTIPLE
#endif

int main(int argc, char** argv) {
    #if defined (_OPENMP)
        int mpi_provided_thread_level;
        MPI_Init_thread( &argc, &argv, THREAD_LEVEL, &mpi_provided_thread_level);
        if ( mpi_provided_thread_level < THREAD_LEVEL ) 
        {
            switch(THREAD_LEVEL)
            {
                case MPI_THREAD_FUNNELED:
                    printf("a problem arise when asking for MPI_THREAD_FUNNELED level\n");
                    MPI_Finalize();
                    exit( 1 );
                    break;
                case MPI_THREAD_SERIALIZED:
                    printf("a problem arise when asking for MPI_THREAD_SERIALIZED level\n");
                    MPI_Finalize();
                    exit( 1 );
                    break;
                case MPI_THREAD_MULTIPLE:
                    printf("a problem arise when asking for MPI_THREAD_MULTIPLE level\n");
                    MPI_Finalize();
                    exit( 1 );
                    break;
            }
        }
    #else
        MPI_Init(NULL, NULL);
    #endif

    char processor_name[MPI_MAX_PROCESSOR_NAME];
    int name_len;
    MPI_Get_processor_name(processor_name, &name_len);
	
	global_context_t ctx;

	ctx.mpi_communicator = MPI_COMM_WORLD;
	get_context(&ctx);

    #if defined (_OPENMP)
        mpi_printf(&ctx,"Running Hybrid (Openmp + MPI) code\n");
    #else
        mpi_printf(&ctx,"Running pure MPI code\n");
    #endif

    #if defined (THREAD_FUNNELED)
        mpi_printf(&ctx,"/!\\ Code build with MPI_THREAD_FUNNELED level\n");
    #else
        mpi_printf(&ctx,"/!\\ Code build with MPI_THREAD_MULTIPLE level\n");
    #endif

	/*
	 * Mock reading some files, one for each processor
	 */

	int d = 5;
	
	float_t* data;

	/*
	 * Generate a random matrix of lenght of some kind
	 */
	if(ctx.mpi_rank == 0)
	{
		simulate_master_read_and_scatter(5, 1000000, &ctx);	
	}
	else
	{
		simulate_master_read_and_scatter(0, 0, &ctx);	
	}

	//free(data);
	free_context(&ctx);
    MPI_Finalize();
}



