#pragma once
#include "../tree/tree.h"

#define PREALLOC_BORDERS 100
#define MAX_SERIAL_MERGING 100

typedef struct border_t 
{
    float_t density;
    float_t error;
    idx_t idx;
} border_t;

typedef struct sparse_border_t 
{
    idx_t i;
    idx_t j;
    idx_t idx;
    float_t density;
    float_t error;
} sparse_border_t;

typedef struct adj_list_t 
{
    idx_t count;
    idx_t size;
    struct sparse_border_t* data;
} adj_list_t;


typedef struct clusters_t 
{
    int use_sparse_borders;
    struct adj_list_t *sparse_borders;
    struct lu_dynamic_array_t centers;
    struct border_t **borders;
    struct border_t *__borders_data;
    idx_t n;
} clusters_t;

typedef struct merge_t 
{
    idx_t source;
    idx_t target;
    float_t density;
} merge_t;



void compute_density_kstarnn_rma(global_context_t* ctx, const float_t d, int verbose);
void compute_density_kstarnn_rma_v2(global_context_t* ctx, const float_t d, int verbose);
float_t compute_ID_two_NN_ML(global_context_t* ctx, datapoint_info_t* dp_info, idx_t n, int verbose);
void clusters_allocate(clusters_t * c, int s);

clusters_t Heuristic1(global_context_t *ctx, int verbose);
void Heuristic2(global_context_t* ctx, clusters_t* cluster);
void Heuristic3(global_context_t* ctx, clusters_t* cluster, float_t Z, int halo);
void clusters_free(clusters_t * c);
