#pragma once 
#include "../common/common.h"
#include "heap.h"
#include "kdtreeV2.h"
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <math.h>
#include <math.h>
#include <omp.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <string.h>

#define DTHR 23.92812698
#define PI_F 3.1415926f
#define ARRAY_INCREMENT 500
#define DA_DTYPE idx_t
#define NOBORDER MY_SIZE_MAX

#define VERBOSE_TRUE 1
#define VERBOSE_FALSE 0


typedef struct mpi_double_int{
	float_t val;
	int key;
} mpi_double_int;

typedef struct guess_t
{
	float_t x_guess;
	int bin_idx;
	float_t ep; 

} guess_t;


typedef struct partition_t
{
	int d;
	int n_procs;
	int start_proc;
	size_t n_points;
	float_t* base_ptr;
	int lr;
	struct top_kdtree_node_t* parent;
} partition_t;

typedef struct partition_queue_t
{
	int count;
	int _capacity;
	struct partition_t* data;
} partition_queue_t;


typedef struct top_kdtree_node_t
{
	float_t split_val;
	float_t* lb_node_box; //Needed? 
	float_t* ub_node_box; //Needed?
	int owner;
	int split_dim;
	size_t n_points;
	struct top_kdtree_node_t* lch;
	struct top_kdtree_node_t* rch;
	struct top_kdtree_node_t* parent;
} top_kdtree_node_t;

typedef struct top_kdtree_t
{
	int dims;
	size_t count;
	size_t _capacity;
	struct top_kdtree_node_t* _nodes;
	struct top_kdtree_node_t* root;

} top_kdtree_t;






void simulate_master_read_and_scatter(int, size_t, global_context_t* ); 



