#pragma once
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>
#include <stdint.h>
//#include <stdarg.h>

#ifdef USE_FLOAT32
	#define float_t float
#else
	#define float_t double
#endif

#define MY_TRUE  1
#define MY_FALSE 0

#define DB_PRINT(...) printf(__VA_ARGS__)
#ifdef NDEBUG
	#undef DB_PRINT(...)
	#define DB_PRINT(...)
#endif

#define MPI_DB_PRINT(...) mpi_printf(ctx,__VA_ARGS__)
#ifdef NDEBUG
	#undef MPI_DB_PRINT(...)
	#define MPI_DB_PRINT(...)
#endif

#define MPI_PRINT(...) mpi_printf(ctx,__VA_ARGS__)

#define MAX(A,B) ((A) > (B) ? (A) : (B))
#define MIN(A,B) ((A) < (B) ? (A) : (B))

/*
 * from Spriengel code Gadget4
 */

#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 202000L
/* C2x does not require the second parameter for va_start. */
#define va_start(ap, ...) __builtin_va_start(ap, 0)
#else
/* Versions before C2x do require the second parameter. */
#define va_start(ap, param) __builtin_va_start(ap, param)
#endif
#define va_end(ap)          __builtin_va_end(ap)
#define va_arg(ap, type)    __builtin_va_arg(ap, type)

struct global_context_t 
{
	size_t n_points;
	size_t idx_start;
	size_t local_n_points;
	uint32_t dims;
	float_t* local_data;
	float_t* lb_box;
	float_t* ub_box;
	int world_size; 
	int mpi_rank;
	int __processor_name_len;
	char processor_mame[MPI_MAX_PROCESSOR_NAME];
	MPI_Comm mpi_communicator;
};

struct pointset_t
{
	size_t n_points;
	size_t __capacity;
	uint32_t dims;
	float_t* data;
	float_t* lb_box;
	float_t* ub_box;
};

typedef struct pointset_t pointset_t;
typedef struct global_context_t global_context_t;

void mpi_printf(global_context_t*, const char *fmt, ...);
void get_context(global_context_t*);
void print_global_context(global_context_t* );
void free_context(global_context_t* );
void free_pointset(pointset_t* );

void generate_random_matrix(float_t** ,int ,size_t ,global_context_t*);


