pro pisces_on_axe_mask_2, wavefront, wavelength, gridsize, sampling, PASSVALUE=passval



diam = 8.4d				;-- entrance aperture diameter in meters
focal_ratio = 15.0d
focal_length = diam*focal_ratio
;beam_ratio = 0.8

prop_begin, wavefront, diam, wavelength, gridsize, passval.beam_ratio


prop_add_phase, wavefront,passval.fase

sam=prop_get_sampling(wavefront)



IF PASSVAL.OSCILLATION EQ 1 THEN BEGIN
rn=randomu(seed, 1)
ax= PASSVAL.SWING_A*rn
ay= PASSVAL.SWING_A*(1.-rn)
PROP_ZERNIKES, WAVEFRONT, 2, ax
PROP_ZERNIKES, WAVEFRONT, 3, ay

ENDIF



prop_circular_aperture, wavefront, diam/2.  

prop_define_entrance, wavefront
prop_circular_obscuration, wavefront, 0.5
;prop_propagate, wavefront, 10,'M1'

prop_lens, wavefront, focal_length
prop_propagate, wavefront, focal_length,'focal plane'





;occrad = 3;5.3
;-- occulter radius in lam/D
;occrad_rad = occrad * wavelength / diam
;-- occulter radius in radians
;dx_m = prop_get_sampling(wavefront)
;dx_rad = prop_get_sampling_radians(wavefront)
;occrad_m = occrad_rad * dx_m / dx_rad
;-- occulter radius in meters




if passval.occtype eq 'gauss' then begin
r = prop_radius( wavefront )
h = sqrt(-0.5 * passval.occulter^2 / alog(1 - sqrt(0.5)))
gauss_spot = 1 - exp(-0.5*(r/h)^2)
prop_multiply, wavefront, gauss_spot
endif else begin
prop_circular_obscuration, wavefront, passval.occulter, passval.xoff, passval.yoff
endelse

;tvframe, prop_get_amplitude(wavefront)^2.
;stop


prop_propagate, wavefront, 0.05,'collimator'
prop_lens, wavefront, 0.05
prop_propagate, wavefront, 0.05,'lyot'

;aggiungi NCPA Zernike modes
prop_zernikes, wavefront, passval.zer_num, passval.zer_val*1e-9


beam=PROP_GET_BEAMRADIUS(wavefront)
prop_circular_aperture, wavefront, beam*(passval.lyotstop), passval.lyot_xoff, passval.lyot_yoff     ;Lyot *******************


;prop_circular_aperture, wavefront, passval.lyotstop,/norm     ;Lyot *******************


prop_circular_obscuration, wavefront, passval.suppressor,/norm  ;secondary spot suppressor


prop_propagate, wavefront, 0.05,'camera'
prop_lens, wavefront, 0.05
prop_propagate, wavefront, 0.05,'detector'
pix=prop_get_sampling_arcsec(wavefront)*1000.
passval.sampl=pix
prop_end, wavefront, sampling

return
end
