# CHANGELOG
All changes to the Metis L1 pipeline are documented in this file.

## 3.0 - 2021-07-19
- Modify the pipeline to manage the new input I/F which includes the full set of Solar Orbiter SPICE kernels and the Metis Calibration Package. In the input file contents.json, the two fields TLS_FILE_NAME and TSC_FILE_NAME are now replaced by the field SPICE_KERNELS providing the path of the Solar Orbiter SPICE kernels folder. The field CAL_PACK_PATH is added to provide the path of the Metis Calibration Package folder.
- Add the WCS (World Coordinate System) keywords to the FITS header and a set of routines to perform calculation of the instrument boresight parameters and S/C coordinates.
- Add the derivation of the quality matrix which is now included in an extension to the L1 FITS file.
- Include several code optimisations.

## 2.3.1 - 2021-04-19
- Fix a bug that caused an incorrect FITS file format: images with unsigned or long integer data type were saved as signed integers with the wrong BSCALE and BZERO scale keywords.

## 2.3 - 2021-03-10
- Fix a bug that caused incorrect pixel counts in re-binned images. Pixel counts are now correctly multiplied by the square of the binning factor after re-binning.
- Introduce the correction for the total effective exposure time: pixel counts are now multiplied by the number of frames that were averaged during the acquisition, so as not to change the real signal-to-noise statistics in each pixel, related to counts integrated over the total effective exposure time. The XPOSURE and NSUMEXP keywords of the FITS, which are affected, are properly updated using parameters DIT, NDIT, NDIT1, and NDIT2.
- Add the HV_TEMP keyword in the FITS header of UV images.
- Fix a bug that caused some keywords in the FITS header of light curves to be incorrectly ordered.

## 2.2.1 – 2021-02-23
- Minor changes and optimisations.

## 2.2 – 2020-11-25
- Change the way how the house-keeping parameters are saved into the FITS binary table, in order to prevent very long computation times when the house-keeping parameter table is large in data volume.
- Modify the decode_obt.pro routine to fix a bug that caused the OBT_BEG and OBT_END keyword values to be converted from double to long.
- Optimise some keyword description texts in the FITS header.
- Add the make_bin_table.pro routine.
- Remove the strreplace.pro routine.

## 2.1 – 2020-11-13
- Fix a bug that triggered the re-binning of VL images even when not necessary.
- Fix a bug that caused an error in writing the log file for data products that are not images (e.g., light curves).

## 2.0 – 2020-10-06
- Include the re-binning of images that had been acquired with binning enabled, so that the size of the data in the FITS is consistent with the commanded binning.
- Modify the interpolation method of house-keeping parameters to manage cases in which interpolation fails, avoiding output values such as “NaN” or “Inf”.
- Add conversion to string for all the keywords of the scientific header that are boolean type.
- Include the generation of a log file with information on the processing and errors, useful for debugging.

## 1.1 – 2020-04-21
- Modify the interpolation method of house-keeping parameters to take into account:
	- the possible lack of a parameter;
	- the possible presence of an uncalibrated parameter (whose engineering value is flagged with “N/A”);
	- the fact that the GEN_TIME keyword is provided in UTC rather than OBT.
- Fix a bug that prevented the correct update of some keywords of the FITS header, in particular those related to sensor temperatures, whose values are interpolated using the input house-keeping parameter table.
- Add correct computation of the TELAPSE and XPOSURE keywords.
- Include the EMPTY_PARAMS field in the output auxiliary JSON file, containing the list of house-keeping parameters in the input table that are not calibrated but which have been interpolated to correct the value of some of the FITS header keywords.
- Revise the structure of the binary table containing the house-keeping parameters to make it more user-friendly.

## 1.0 – 2020-03-06
- Add the decode_obt.pro routine.
- Include several code optimisations.

## 0.0 – 2020-01-16
Prototype version of the L1 pipeline.
