pro load_spice_kernels, path, unload = unload, kernel_list = kernel_list, kernel_version = kernel_version
	if keyword_set(unload) then cspice_kclear else begin
		metakernel = path + '/mk/solo_ANC_soc-flown-mk.tm'
		openr, in, metakernel, /get_lun
		kernel_list = list()
		while ~ eof(in) do begin
			line = ''
			readf, in, line
			if line.contains('$KERNELS', /fold) then begin
				line = line.replace('$KERNELS', path)
				line = line.replace("'", '')
				kernel_list.add, line.trim()
			endif
			if line.contains('SKD_VERSION', /fold) then begin
				fields = stregex(line, ".*'([a-z_0-9]*)'", /extract, /sub)
				kernel_version = fields[1]
			endif
		endwhile
		close, /all
		foreach item, kernel_list do cspice_furnsh, item
	endelse
end
