function make_bin_table, table
    n = n_elements(table.gen_time)
    gen_time = dblarr(n)
    for k = 0, n - 1 do gen_time[k] = date_conv(table.gen_time[k], 'JULIAN')

    s = where(table.eng_val.contains('N/A'), count)
    if count gt 0 then table.eng_val[s] = table.raw_val[s]

    par_names = table.par_name
    s = sort(par_names)
    par_names = par_names[s]
    u = uniq(par_names)
    par_names = par_names[u]

    bin_table = !null
    foreach par_name, par_names do begin
        sample = where(table.par_name eq par_name)

        min_time = min(gen_time[sample], i)
        j = sample[i]
        param = create_struct( $
            'PAR_NAME', par_name, $
            'GEN_TIME', date_conv(gen_time[j], 'FITS'), $
            'RAW_VAL', table.raw_val[j], $
            'ENG_VAL', table.eng_val[j], $
            'UNIT', table.unit[j], $
            'DESCR', table.desc[j])
        bin_table = [bin_table, param]

        max_time = max(gen_time[sample], i)
        j = sample[i]
        param = create_struct( $
            'PAR_NAME', par_name, $
            'GEN_TIME', date_conv(gen_time[j], 'FITS'), $
            'RAW_VAL', table.raw_val[j], $
            'ENG_VAL', table.eng_val[j], $
            'UNIT', table.unit[j], $
            'DESCR', table.desc[j])
        bin_table = [bin_table, param]

        avg_time = (min_time + max_time)/2
        i = max(where(gen_time[sample] le avg_time))
        j = sample[i]
        param = create_struct( $
            'PAR_NAME', par_name, $
            'GEN_TIME', date_conv(gen_time[j], 'FITS'), $
            'RAW_VAL', table.raw_val[j], $
            'ENG_VAL', table.eng_val[j], $
            'UNIT', table.unit[j], $
            'DESCR', table.desc[j])
        bin_table = [bin_table, param]

        if product(table.eng_val[sample].matches('^-?[0-9]+')) then begin
            min_val = min(float(table.eng_val[sample]), i)
            j = sample[i]
            param = create_struct( $
                'PAR_NAME', par_name, $
                'GEN_TIME', date_conv(gen_time[j], 'FITS'), $
                'RAW_VAL', table.raw_val[j], $
                'ENG_VAL', table.eng_val[j], $
                'UNIT', table.unit[j], $
                'DESCR', 'Min. value of ' + table.desc[j])
            bin_table = [bin_table, param]

            max_val = max(float(table.eng_val[sample]), i)
            j = sample[i]
            param = create_struct( $
                'PAR_NAME', par_name, $
                'GEN_TIME', date_conv(gen_time[j], 'FITS'), $
                'RAW_VAL', table.raw_val[j], $
                'ENG_VAL', table.eng_val[j], $
                'UNIT', table.unit[j], $
                'DESCR', 'Max. value of ' + table.desc[j])
            bin_table = [bin_table, param]

            param = create_struct( $
                'PAR_NAME', par_name, $
                'GEN_TIME', 'N/A', $
                'RAW_VAL', string(mean(fix(table.raw_val[sample])), format = '(I0)'), $
                'ENG_VAL', string(mean(double(table.eng_val[sample])), format = '(D0.16)'), $
                'UNIT', (table.unit[sample])[0], $
                'DESCR', 'Average value of ' + (table.desc[sample])[0])
            bin_table = [bin_table, param]
        endif
    endforeach

    return, bin_table
end
