function check_quality, data, cal_pack, filter
	
	if not keyword_set(filter) then filter = 'VL'
	
	if filter.contains('VL', /fold) then channel = cal_pack.vl_channel else channel = cal_pack.uv_channel

	levels = channel.sat_level.value

	quality_matrix = float(data) * 0.

	s1 = where(data le levels[0], count)
	if count gt 0 then quality_matrix[s1] = !values.f_nan

	s2 = where(data gt levels[0] and data le levels[1], count)
	if count gt 0 then quality_matrix[s2] = 0

	s3 = where(data gt levels[1] and data lt levels[2], count)
	if count gt 0 then quality_matrix[s3] = 1

	s4 = where(data ge levels[2] and data lt levels[3], count)
	if count gt 0 then quality_matrix[s4] = 0

	s5 = where(data ge levels[3], count)
	if count gt 0 then quality_matrix[s5] = !values.f_nan

	return, quality_matrix
end
