function interpol_param, table, par_name, date, empty_params = empty_params
	if not keyword_set(empty_params) then empty_params = !null
	s = where(table.par_name eq par_name, n)
	if n eq 0 then begin
		journal, 'Error 01: parameter not found in house-keeping table.'
		journal
		exit, status = 1
	endif
	if n eq 1 then begin
		journal, 'Error 02: insufficient number of parameter values in house-keeping table.'
		journal
		exit, status = 2
	endif
	par_time = table.gen_time[s]
	par_val = table.eng_val[s]
	par_date = dblarr(n)
	for i = 0, n - 1 do par_date[i] = date_conv(par_time[i], 'JULIAN')
	if max(par_val.contains('N/A')) then begin
		empty_params = [empty_params, par_name]
		par_val = table.raw_val[s]
	endif
	s = sort(par_date)
	par_val = par_val[s]
	par_date = par_date[s]
	jul_date = date_conv(date, 'JULIAN')
	if jul_date ge min(par_date) and jul_date le max(par_date) then value = interpol(float(par_val), par_date, jul_date) else begin
		journal, 'Error 02: insufficient number of parameter values in house-keeping table.'
		journal
		exit, status = 2
	endelse
	if finite(value) then return, value else begin
	  	journal, 'Error 03: interpolation of HK parameter ' + par_name.trim() + ' failed.'
		journal
		exit, status = 3
	endelse
end
