function solo_obt2utc, obt

	; check if obt is in the correct form (string, with coarse and fine times)
	
	if isa(obt, /number) then obt = decode_obt(obt, /from_decimal)

	; convert the requested obt into ephemeris time

	cspice_scs2e, -144L, obt, et

	; convert the ephemeris time into utc

	cspice_et2utc, et, 'ISOC', 3, utc

	return, utc
end
