pro fix_fits_header, filename
    fits_info, filename, n_ext = n_ext, /silent
    for ext = 0, n_ext do begin
        data = readfits(filename, header, exten_no = ext, /noscale, /silent)
        for k = 0, n_elements(header) - 1 do begin
            while header[k].matches('\/  +') do begin
                header[k] = header[k].replace('/  ', '/ ')
            endwhile
        endfor
        fits_add_checksum, header, data
        modfits, filename, 0, header, exten_no = ext
    endfor
end