function solo_get_coords, utc, frame, observer, spherical = spherical, degrees = degrees, velocity = velocity

	; convert the requested date into ephemeris time

	cspice_str2et, utc, et

	; switch to the proper solar orbiter frame

	if ('carrington').contains(frame, /fold) then frame = 'IAU_SUN'

	case frame.toupper() of
		'RTN' : frame = 'SOLO_SUN_RTN'
		'HEE' : frame = 'SUN_EARTH_ECL'
		'HCI' : frame = 'SUN_INERTIAL'
		'HAE' : frame = 'SUN_ARIES_ECL'
		'HEQ' : frame = 'SUN_EARTH_CEQU'
		'GSE' : frame = 'EARTH_SUN_ECL'
		'GEI' : frame = 'J2000'
		else : frame = frame
	endcase

	; coordinates of the s/c in the selected reference frame

	cspice_spkezr, 'SOLO', et, frame, 'NONE', observer, state, light_time

	coord = state[0 : 2]

	; convert rectangular coordinates into angular coordinates

	if keyword_set(spherical) then begin
		cspice_reclat, coord, solo_dist, solo_lon, solo_lat
		if frame eq 'IAU_SUN' then solo_lon = (solo_lon + 2. * !dpi) mod (2. * !dpi)
		if keyword_set(degrees) then begin
			solo_lat = solo_lat * 180.D0/!dpi
			solo_lon = solo_lon * 180.D0/!dpi
		endif
		coord = [solo_dist, solo_lon, solo_lat]
	endif

	velocity = state[3 : 5]

	return, coord
end
