function metis_dark_uvda, data, header, cal_pack, history = history

	dark = cal_pack.uv_channel.dark

	dit = header.dit/1000.D0
	ndit1 = header.ndit1
	ndit2 = header.ndit2
	nbin = sqrt(header.nbin)
	tsensor = header.tsensor
	obj_cnt = header.obj_cnt
	obt_beg = header.obt_beg

	for i = 0, n_elements(dark) - 1 do begin
		if (dark[i].dit eq dit) and (dark[i].nbin eq nbin) and (dark[i].ndit1 eq ndit1) and (dark[i].ndit2 eq ndit2) and (abs(dark[i].tsensor - tsensor) lt 5) and (abs(obt_beg - dark[i].obt_beg) lt (3600 * 24 * 10)) then begin
			if obj_cnt eq 1 then begin
				dark_file = dark[i].file_name.cnt_1
				dark_image = float(readfits(cal_pack.path + dark[i].file_name.cnt_1, /silent))
				dark_image = rebin(dark_image, header.naxis1, header.naxis2) * nbin^2
				mask = where(data eq 0., count)
				data = data - dark_image * ndit1 * ndit2
				data[mask] = 0.

				goto, jump
			endif else begin
				dark_file = dark[i].file_name.cnt_2
				dark_image = float(readfits(cal_pack.path + dark[i].file_name.cnt_2, /silent))
				dark_image = rebin(dark_image, header.naxis1, header.naxis2) * nbin^2
				mask = where(data eq 0., count)
				data = data - dark_image * ndit1 * ndit2
				data[mask] = 0.

				goto, jump
			endelse
		endif
	endfor

	obt_available = !null
	for i = 0, n_elements(dark) - 1 do begin
		if (dark[i].dit eq dit) and (abs(dark[i].tsensor - tsensor) lt 5) then begin
			obt_available = [obt_available, dark[i].obt_beg]
		endif
	endfor

	delta_obt = min(abs(obt_beg - obt_available), j)
	i = where(dark.obt_beg eq obt_available[j])

	if obj_cnt eq 1 then begin
		if (ndit1 eq dark[i].ndit1) and (ndit2 eq dark[i].ndit2) then begin
			dark_image = float(readfits(cal_pack.path + dark[i].file_name.cnt_1, /silent))
			dark_file = dark[i].file_name.cnt_1
		endif else begin
			q = ndit2/dark[i].ndit2
			dark_1 = float(readfits(cal_pack.path + dark[i].file_name.cnt_1, /silent))
			dark_2 = float(readfits(cal_pack.path + dark[i].file_name.cnt_2, /silent))
			dark_image = (dark_1 + (q - 1) * dark_2)/q
			dark_file = dark[i].file_name.cnt_1 + ' - ' + dark[i].file_name.cnt_2
		endelse
	endif else begin
		dark_image = float(readfits(cal_pack.path + dark[i].file_name.cnt_2, /silent))
		dark_file = dark[i].file_name.cnt_2
	endelse

	dark_image = rebin(dark_image, header.naxis1, header.naxis2) * nbin^2

	mask = where(data eq 0., count)
	data = data - dark_image * ndit1 * ndit2
	data[mask] = 0.

	jump:

	if ~ isa(history) then history = !null
	history = [history, 'Dark correction: ', '  ' + dark_file]

	return, data
end
