function metis_vignetting, data, header, cal_pack, history = history

	if header.filter.contains('VL', /fold) then vig_info = cal_pack.vl_channel.vignetting
	if header.filter.contains('UV', /fold) then vig_info = cal_pack.uv_channel.vignetting

	vig_image = readfits(cal_pack.path + vig_info.file_name, /silent)
	vig_image = median(vig_image, 5)
	vig_file = vig_info.file_name

	dx = 0.
	dy = 0.

	if header.filter.contains('UV', /fold) then begin
		vl_boresight = cal_pack.vl_channel.boresight[0]
		uv_boresight = cal_pack.uv_channel.boresight[0]

		x1 = uv_boresight.borpix1.value
		x2 = vl_boresight.borpix1.value
		y1 = uv_boresight.borpix2.value
		y2 = vl_boresight.borpix2.value

		plate_scale = vl_boresight.plate_scale.value
		dx = (x1 - x2)/plate_scale
		dy = (y1 - y2)/plate_scale

		vig_image = rotate(vig_image, 1)
		vig_image = shift(vig_image, dx, dy)
		vig_image[2047 - abs(dx) : 2047, *] = 0.
		vig_image[*, 0 : abs(dy) - 1] = 0.
		vig_image = rotate(vig_image, 3)
		vig_image = reverse(vig_image, 1)
	endif

	vig_image = rebin(vig_image, header.naxis1, header.naxis2)
	vig_image = (vig_image > 0.) < 1.

	mask = where(vig_image eq 0.)
	vig_image[mask] = 1.

	data = data / vig_image
	data[mask] = 0.

	if ~ isa(history) then history = !null
	history = [history, 'Vignetting correction: ', '  ' + vig_file + ' shifted by [' + string(dx, format = '(f0.1)') + ', ' + string(dy, format = '(f0.1)') + '] pixel']

	return, data
end
