function solo_get_carrot, utc

	; initial estimate of the carrington rotation number

	jul_day = date_conv(utc, 'julian')

	carr = (jul_day - 2398167.D0)/27.2753D0 + 1

	; convert the requested date into ephemeris time

	cspice_str2et, utc, et

	; get the carrington longitude of earth

	cspice_spkezr, 'EARTH', et, 'IAU_SUN', 'NONE', 'SUN', state, ltime

	; convert rectangular coordinates into angular coordinates

	cspice_reclat, state[0 : 2], sun_dist, he_lon, he_lat

	; calculate the fractional part of the decimal rotation number

	if he_lon lt 0. then he_lon = he_lon + 2. * !dpi
	frac = 1.D0 - he_lon/(2. * !dpi)
	n_carr = round(carr - frac)
	carr = n_carr + frac

	; correction for s/c position

	cspice_spkezr, 'SOLO', et, 'SUN_EARTH_CEQU', 'NONE', 'SUN', state, ltime

	; convert rectangular coordinates into angular coordinates

	cspice_reclat, state[0 : 2], so_dist, so_lon, so_lat

	carr = carr - so_lon/(2. * !dpi)

	return, carr
end
