function metis_rad_cal, data, header, cal_pack, polarimetric = polarimetric, history = history

	if header.filter.contains('VL', /fold) then begin

		; NOTE - this is to take into account that calibration of polarimetric images or their combination, must not include the pmp efficiency (0.5) since this is included in the demodulation formulae

		if keyword_set(polarimetric) then pmp_factor = 2.d0 else pmp_factor = 1.d0

		angular_pixel = cal_pack.vl_channel.angular_pixel.value * header.nbin
		rad_info = cal_pack.vl_channel.radiometry[0]
		units = cal_pack.vl_channel.cal_units
		unit_factor = rad_info.msb.value
	end

	if header.filter.contains('UV', /fold) then begin
		angular_pixel = cal_pack.uv_channel.angular_pixel.value * header.nbin
		rad_info = cal_pack.uv_channel.radiometry[0]
		units = cal_pack.uv_channel.cal_units
		pmp_factor = 1.d0
		unit_factor = 1.
	endif

	rad_factor = rad_info.rad_response.value * pmp_factor * $
		cal_pack.instrument.pupil_area.value * $
		angular_pixel * $
		unit_factor

	cal_factor = 1. / rad_factor / header.xposure

	data = data * cal_factor

	if ~ isa(history) then history = !null
	history = [history, 'Radiometric calibration:', '  cal. factor = ' + string(cal_factor, format = '(E8.2)') + ' ' + units + '/DN']

	return, data
end
