function solo_get_pointing, utc, degrees = degrees, radians = radians, celestial = celestial

	; convert the requested date into ephemeris time

	cspice_str2et, utc, et

	; convert the ephemeris time into s/c internal time

	cspice_sce2c, -144L, et, clk_in

	; set the proper solar orbiter frame

	frame = 'SOLO_SUN_RTN'

	if keyword_set(celestial) then frame = 'J2000'

	cspice_ckgp, -144000L, clk_in, 1, frame, cmat, clk_out, found

	if found then cspice_m2eul, cmat, 1, 2, 3, roll, pitch, yaw else return, replicate(0., 3)

	; make the conversion form rtn to hpc, if necessary

	if frame eq 'SOLO_SUN_RTN' then begin
		yaw = !dpi * signum(yaw) - yaw
		pitch = -pitch
		roll = -roll
	endif else begin
		pitch = -pitch
	endelse

	; correct any cases where the roll is greater than +/- 180 degrees

	if abs(roll) gt !dpi then roll = roll - 2.d0 * !dpi * signum(roll)

	; correct any cases where the pitch is greater than +/- 90 degrees

	if abs(pitch) gt !dpi / 2.d0 then begin
		yaw = yaw - !dpi * signum(yaw)
		pitch = !dpi * signum(pitch) - pitch
		roll = roll - !dpi * signum(roll)
	endif

	; apply correct units to the pointing vector

	if keyword_set(radians) then rad_factor = 1. else rad_factor = 180.d0 / !dpi
	if keyword_set(radians) or keyword_set(degrees) then arc_factor = 1. else arc_factor = 3600.

	yaw = yaw * rad_factor * arc_factor
	pitch = pitch * rad_factor * arc_factor
	roll = roll * rad_factor

	return, [yaw, pitch, roll]
end
