function metis_dark_vlda, data, header, cal_pack, history = history

	bias = cal_pack.vl_channel.bias
	dark = cal_pack.vl_channel.dark
	bias_dark = cal_pack.vl_channel.bias_dark

	dit = header.dit/1000.D0
	ndit = header.ndit
	nbin = sqrt(header.nbin)
	tsensor = header.tsensor
	obt_beg = header.obt_beg/1000.D0 ; check why obt_beg must be divided by 1000.

	; WARN - temporary patch to handle local l1 fits files
	; if tsensor eq 0. then tsensor = -30.

	for i = 0, n_elements(bias_dark) - 1 do begin
		if bias_dark[i].dit eq dit and bias_dark[i].nbin eq nbin and abs(bias_dark[i].tsensor - tsensor) lt 5. then begin
			dark_file = bias_dark[i].file_name
			dark_image = float(readfits(cal_pack.path + dark_file, /silent))
			dark_image = rebin(dark_image, header.naxis1, header.naxis2) * nbin^2 * ndit
			
			mask = where(data eq 0.)
			data = data - dark_image
			data[mask] = 0.

			goto, jump
		endif
	endfor

	bias_obt_available = !null
	for i = 0, n_elements(bias) - 1 do begin
		if abs(bias[i].tsensor - tsensor) lt 5. then bias_obt_available = [bias_obt_available, bias[i].obt_beg]
	endfor

	if isa(bias_obt_available) then begin
		delta_obt = min(abs(obt_beg - bias_obt_available), j)
		i = where(bias.obt_beg eq bias_obt_available[j])
		bias_image = float(readfits(cal_pack.path + bias[i].file_name, /silent))
		dark_file = bias[i].file_name
	endif else begin
		bias_image = fltarr(header.naxis1, header.naxis2)
		dark_file = 'applicable bias file not found - correction not applied'
	endelse

	dark_obt_available = !null
	for i = 0, n_elements(dark) - 1 do begin
		if abs(dark[i].tsensor - tsensor) lt 5. then dark_obt_available = [dark_obt_available, dark[i].obt_beg]
	endfor

	if isa(dark_obt_available) then begin
		delta_obt = min(abs(obt_beg - dark_obt_available), j)
		i = where(dark.obt_beg eq dark_obt_available[j])
		dark_image = float(readfits(cal_pack.path + dark[i].file_name, /silent))
		dark_file = [dark_file, dark[i].file_name]
	endif else begin
		dark_image = fltarr(header.naxis1, header.naxis2)
		dark_file =  [dark_file, 'applicable dark file not found - correction not applied']
	endelse

	bias_image = rebin(bias_image, header.naxis1, header.naxis2) * nbin^2
	dark_image = rebin(dark_image, header.naxis1, header.naxis2) * nbin^2

	mask = where(data eq 0.)
	data = data - (bias_image * ndit + header.xposure * dark_image)
	data[mask] = 0.

	jump:

	if ~ isa(history) then history = !null
	history = [history, 'Bias and dark-current corrections: ', '  ' + dark_file]

	return, data
end
