function metis_flat_field, data, header, cal_pack, history = history

	if header.filter.contains('VL', /fold) then begin
		ff_info = cal_pack.vl_channel.flat_field

		ff_image = readfits(cal_pack.path + ff_info.file_name, /silent)
		ff_file = ff_info.file_name

		first_row = header.ref_rows eq 'Included' ? 2 : 0
		detector_size = cal_pack.vl_channel.detector_size.value
		ff_image = ff_image[*, first_row : first_row + detector_size - 1]
	endif

	if header.filter.contains('UV', /fold) then begin
		ff_info = cal_pack.uv_channel.flat_field

		nbin = sqrt(header.nbin)
		i = where(ff_info.nbin eq nbin)
		ff_image = readfits(cal_pack.path + ff_info[i].file_name, /silent)
		ff_file = ff_info[i].file_name
	endif

	ff_image = rebin(ff_image, header.naxis1, header.naxis2)
	
	mask = where(ff_image le 0.)
	ff_image[mask] = 1.
	data = data / ff_image
	data[mask] = 0.

	if ~ isa(history) then history = !null
	history = [history, 'Flat-field correction: ', '  ' + ff_file]

	return, data
end
