function solo_get_solar_angles, utc

	; convert the requested date into ephemeris time

	cspice_utc2et, utc, et

	cspice_pxform, 'IAU_SUN', 'J2000', et, rot
	sun_north = rot[2, *]

	cspice_spkezr, 'SUN', et, 'J2000', 'NONE', 'SOLO', state, ltime
	coord = state[0 : 2]
	rad = coord/sqrt(total(coord^2, 1))

	cel_north = [0., 0., 1.D0]

	sun_proj = sun_north - total(rad * sun_north) * rad
	sun_proj = sun_proj/sqrt(total(sun_proj^2))

	cel_proj = cel_north - total(rad * cel_north) * rad
	cel_proj = cel_proj/sqrt(total(cel_proj^2))

	vec_proj = crossp(cel_north, rad)
	vec_proj = vec_proj/sqrt(total(vec_proj^2))

	x_proj = total(sun_proj * cel_proj)
	y_proj = total(sun_proj * vec_proj)

	p0 = atan(y_proj, x_proj) * 180.D0/!dpi

	cspice_pxform, 'IAU_SUN', 'ECLIPJ2000', et, rot
	sun_north = rot[2, *]

	cspice_spkezr, 'SUN', et, 'ECLIPJ2000', 'NONE', 'SOLO', state, ltime
	coord = state[0 : 2]
	rad = coord/sqrt(total(coord^2, 1))

	eclip_north = cel_north

	sun_proj = sun_north - total(rad * sun_north) * rad
	sun_proj = sun_proj/sqrt(total(sun_proj^2))

	ecl_proj = eclip_north - total(rad * eclip_north) * rad
	ecl_proj = ecl_proj/sqrt(total(ecl_proj^2))

	vec_proj = crossp(eclip_north, rad)
	vec_proj = vec_proj/sqrt(total(vec_proj^2))

	x_proj = total(sun_proj * ecl_proj)
	y_proj = total(sun_proj * vec_proj)

	ep = atan(y_proj, x_proj) * 180.D0/!dpi

	cspice_spkezr, 'SUN', et, 'IAU_SUN', 'NONE', 'SOLO', state, ltime
	coord = state[0 : 2]

	cspice_reclat, coord, dist, lon, lat

	b0 = -lat * 180.D0/!dpi

	return, [b0, p0, ep]
end
