function get_light_time, utc, target, observer, rad_velocity = rad_velocity

	; convert the requested date into ephemeris time

	cspice_str2et, utc, et

	; coordinates of the target wrt the target in the j2000 system

	cspice_spkezr, target, et, 'J2000', 'NONE', observer, state, light_time

	; radial component of the velocity

	rad_velocity = 1000. * total(state[0 : 2] * state[3 : 5])/sqrt(total(state[0 : 2]^2))

	return, light_time
end
