class artecs_map :
   def __init__(self,filename) :
      import numpy
      try :
         import pyfits
      except :
         from astropy.io import fits as pyfits
      self.filename=filename
      self.p=pyfits.open(filename)
      self._key=[]
      self._value=[]
      self._descr=[]
      mkd=True
      for cc in self.p[0].header.cards :
         if cc[0]!='COMMENT' :
            self._key.append(cc[0])
            self._value.append(cc[1])
            self._descr.append(cc[2])
         else :   
            if mkd :
               self._key.append(cc[0])
               self._value.append('\n'.join(self.p[0].header['COMMENT']))
               self._descr.append(None)
               mkd=False
      self.N=self.parameter('N')
      self.NS=self.parameter('NS')
      self.shape=(self.NS,self.N)
      self.year=self.p[1].data['year']
      self.lat=self.p[1].data['lat']
      self.temp=self.p[1].data['temp']
      self.year.shape=self.shape
      self.lat.shape=self.shape
      self.temp.shape=self.shape
      self.TMGLOB=self.temp.mean()
      self.p.close()
      self.lst_lat=self.lat[0]
      self.lst_year=self.year[:,0].T
   def keys(self) : 
      return self._key
   def has_key(self,key) : 
      return key in self._key
   def parameter(self,key) :
      return self._value[self._key.index(key)]
   def description(self,key) :
      return self._descr[self._key.index(key)]
   def bilinear_interpolation(self,lat,year) :
      pass
