window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "py_artecs", "modulename": "py_artecs", "kind": "module", "doc": "<p>A Python3 library to handle contents of ARTECS: Archive of terrestrial-type climate simulations </p>\n\n<pre><code>http://wwwuser.oats.inaf.it/exobio/climates/\n</code></pre>\n\n<p>through TAP and the PYVO services.</p>\n\n<p>Authors: Michele Maris (1), Marco Molinaro (1)</p>\n\n<pre><code>(1) INAF/Trieste Astronomical Observatory\n</code></pre>\n\n<p>First Issue: 2019 Nov 20</p>\n\n<h2 id=\"dependencies\">Dependencies:</h2>\n\n<p>This package needs: \n   numpy, scipy, pandas, pyvo</p>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>For the latest release:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">pip3</span> <span class=\"n\">install</span> <span class=\"n\">py_artecs</span>\n</code></pre>\n</div>\n\n<p>for the dev version clone this GitLab repository.</p>\n\n<h2 id=\"files-in-py_artecs\">Files in py_artecs</h2>\n\n<p><code>__init__.py</code>   : the init file</p>\n\n<p><code>tap.py</code>        : the file with the TAP library </p>\n\n<p><code>artecs_map.py</code> : a utility class to handle a local fits file with a Temperature MAP downloaded from the archive</p>\n\n<p><code>modelDB.py</code>    : a utility class to handle a local csv file with the result of a query, this module is kept for backward compatibility, but its use is deprecated</p>\n\n<h2 id=\"example-of-session\">Example of session:</h2>\n\n<p>The archive is accessed from the exop_pubblic_tap in py_artecs:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">artecs</span> <span class=\"kn\">import</span> <span class=\"n\">exop_pubblic_tap</span>\n</code></pre>\n</div>\n\n<p>Then instantiate a database object</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">atap</span><span class=\"o\">=</span><span class=\"n\">exop_pubblic_tap</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>all the queries to ARTECS are made through the methods in atap.</p>\n\n<p>Queries follows the Astronomical Data Query Language (ADQL) format</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">ptab</span><span class=\"o\">=</span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">search</span><span class=\"p\">(</span><span class=\"s1\">&#39;power(SMA,1.5)&gt;0.87&#39;</span><span class=\"p\">);</span>\n</code></pre>\n</div>\n\n<p>see the appendix for further references on the ADQL.</p>\n\n<p>To know wether the search is successfull:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">success</span><span class=\"p\">()</span>\n<span class=\"go\">True</span>\n</code></pre>\n</div>\n\n<p>The result of a query is stored in ptab as a PANDAS data_frame.</p>\n\n<p>In order to save the table as a csv file use the \"to_csv\" method of pandas data frame:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">ptab</span><span class=\"o\">.</span><span class=\"n\">to_csv</span><span class=\"p\">(</span><span class=\"s1\">&#39;result.csv&#39;</span><span class=\"p\">,</span><span class=\"n\">sep</span><span class=\"o\">=</span><span class=\"s1\">&#39; &#39;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>In order to get a map corresponding to the first entry in the ptab use:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">TMAP</span><span class=\"o\">=</span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">get_map</span><span class=\"p\">(</span><span class=\"n\">ptab</span><span class=\"o\">.</span><span class=\"n\">URL</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<p>the command creates a fits file to rercover the fits filename</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">MAP</span><span class=\"o\">.</span><span class=\"n\">filename</span><span class=\"p\">)</span>\n<span class=\"go\">/tmp/artecs_download_file_669d40064f5bddc8.fits</span>\n</code></pre>\n</div>\n\n<p>note that the get_map method saved the fits inside the /tmp directory and gives it a dummy name.</p>\n\n<p>To specify a different name and directory use the outfile keyword in get_map</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">TMAP</span><span class=\"o\">=</span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">get_map</span><span class=\"p\">(</span><span class=\"n\">ptab</span><span class=\"o\">.</span><span class=\"n\">URL</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">],</span><span class=\"n\">outfile</span><span class=\"o\">=</span><span class=\"s1\">&#39;./test.fits&#39;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">TMAP</span><span class=\"o\">.</span><span class=\"n\">filename</span><span class=\"p\">)</span>\n<span class=\"go\">./test.fits</span>\n</code></pre>\n</div>\n\n<p>TMAP is an object of class artecs_map, so it contains the temperature MAP in the ARTECS fits file, as well as the other keywords in the original fits file.</p>\n\n<p>Note that the artecs_map class can be used also local copies of the ARTECS temperature maps.</p>\n\n<p>At last, to perform a new query reset the old one with:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">clear</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h2 id=\"appendix-a-adql-queries\">Appendix A: ADQL Queries</h2>\n\n<p>A query is a string \n . SELECTION set of data to be selected\n . HOW_MANY elements to select\n . WHICH_FIELDS fields to select\n . FROM which table\n . WHERE condition for selection is true</p>\n\n<p>Examples of query strings:</p>\n\n<ol>\n<li><p>Download all the data: </p>\n\n<blockquote>\n  <p><code>SELECT * FROM exo.EXO</code></p>\n</blockquote></li>\n<li><p>Download only the first 10 elements:  </p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 * FROM exo.EXO</code></p>\n</blockquote></li>\n<li><p>Download only the first 10 elements with SMA in the range 0.9 to 1.1: </p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 * FROM exo.EXO WHERE SMA BETWEEN 0.9 AND 1.1</code></p>\n</blockquote>\n\n<p>alternativelly</p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 * FROM exo.EXO WHERE (0.9 &lt;= SMA) AND (SMA &lt;= 1.1)</code></p>\n</blockquote></li>\n<li><p>Download only the first 10 elements with SMA in the range 0.9 to 1.1 and CONTHAB>=0.5</p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 * FROM exo.EXO WHERE SMA BETWEEN 0.9 AND 1.1 AND CONTHAB&gt;=0.5</code></p>\n</blockquote></li>\n<li><p>Arithmetic calculations are allowed if needed for selection so to download the first 10 elements with SMA^1.5 &gt; 0.87 </p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 * FROM exo.EXO WHERE power(SMA,1.5)&gt; 0.87</code> </p>\n</blockquote></li>\n<li><p>returns just columns SMA and CONTHAB from previous example:</p>\n\n<blockquote>\n  <p><code>SELECT TOP 10 SMA,CONTHAB FROM exo.EXO WHERE power(SMA,1.5)&gt; 0.87</code> </p>\n</blockquote></li>\n</ol>\n\n<p>Note that the query string is not sensitive to uppercase or lowercase.</p>\n\n<p>For tutorials see: </p>\n\n<ul>\n<li><a href=\"http://www.g-vo.org/tutorials/gaia-mock-tap.pdf\">http://www.g-vo.org/tutorials/gaia-mock-tap.pdf</a></li>\n<li><a href=\"http://www.ivoa.net/documents/REC/ADQL/ADQL-20081030.pdf\">http://www.ivoa.net/documents/REC/ADQL/ADQL-20081030.pdf</a></li>\n<li><a href=\"http://www.ivoa.net/documents/\">http://www.ivoa.net/documents/</a></li>\n</ul>\n\n<p>A reminder of how to form query strings can be recalled by calling:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">atap</span><span class=\"o\">.</span><span class=\"n\">EXPLAIN</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h2 id=\"appendix-b-references\">Appendix B: REFERENCES</h2>\n\n<p>Please quote</p>\n\n<p><em>Climate bistability of Earth-like exoplanets</em></p>\n\n<p>Murante G., Provenzale A., Vladilo G.,Taffoni G., Silva L., Palazzi E.,von Hardenberg J.,Maris M., Londero E., Knapic C., Zorba C.</p>\n\n<p>MNRAS <strong>492</strong>, 2638\u20132650 (2020) </p>\n\n<p>doi: 10.1093/mnras/stz3529</p>\n\n<h2 id=\"appendix-c-example-of-session-with-tap\">Appendix C: Example of session with TAP</h2>\n\n<p>It is possible to access the archive directly with TAP</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">pyvo</span> <span class=\"k\">as</span> <span class=\"nn\">vo</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">tap_service</span> <span class=\"o\">=</span> <span class=\"n\">vo</span><span class=\"o\">.</span><span class=\"n\">dal</span><span class=\"o\">.</span><span class=\"n\">TAPService</span><span class=\"p\">(</span><span class=\"s2\">&quot;http://archives.ia2.inaf.it/vo/tap/exo&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">tap_results</span> <span class=\"o\">=</span> <span class=\"n\">tap_service</span><span class=\"o\">.</span><span class=\"n\">search</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT top 1 exp_id, url FROM exo.EXO&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">tap_results</span><span class=\"p\">)</span>\n<span class=\"go\">&gt;&gt;&gt;...</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">tap_results</span><span class=\"p\">)</span>\n<span class=\"go\">&gt;&gt;&gt;...</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">tap_results</span><span class=\"o\">.</span><span class=\"n\">getrecord</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"go\">&gt;&gt;&gt;...</span>\n</code></pre>\n</div>\n\n<h2 id=\"appendix-d-to-install-pyvo\">Appendix D: to install pyvo</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sudo</span> <span class=\"n\">pip3</span> <span class=\"n\">install</span> <span class=\"n\">pyvo</span>\n</code></pre>\n</div>\n"}, {"fullname": "py_artecs.artecs_map", "modulename": "py_artecs.artecs_map", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map", "kind": "class", "doc": "<p>A class to handle a temperature map from ARTECS.</p>\n\n<p>It reads the artecs_map from a fits file.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">AMAP</span><span class=\"o\">=</span><span class=\"n\">artecs_map</span><span class=\"p\">(</span><span class=\"s2\">&quot;artecs_map.fits&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>Keywords in the map are returned as members of the class or using the method \"parameter\".</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">AMAP</span><span class=\"o\">.</span><span class=\"n\">temp</span> \n</code></pre>\n</div>\n\n<p>returns the temperature map,</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">AMAP</span><span class=\"o\">.</span><span class=\"n\">parameter</span><span class=\"p\">(</span><span class=\"s1\">&#39;temp&#39;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>returns the temperature map.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">AMAP</span><span class=\"o\">.</span><span class=\"n\">shape</span>\n</code></pre>\n</div>\n\n<p>returns the shape of the map (rows, columns)</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.__init__", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.__init__", "kind": "function", "doc": "<p>To instantiate the class pass the filename from which to load the Temperature map</p>\n\n<blockquote>\n  <p>Keywords: </p>\n</blockquote>\n\n<blockquote>\n  <blockquote>\n    <p><code>verbose</code>: if True verbose output</p>\n  </blockquote>\n</blockquote>\n\n<blockquote>\n  <blockquote>\n    <p><code>closeFits</code>: if True the fits file is closed after reading</p>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">closeFits</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span>)</span>"}, {"fullname": "py_artecs.artecs_map.artecs_map.filename", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.filename", "kind": "variable", "doc": "<p>parameter: the filename</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.p", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.p", "kind": "variable", "doc": "<p>the fits file pointer, normally closed.</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.lst_lat", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.lst_lat", "kind": "variable", "doc": "<p>list of latitude bands</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.lst_year", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.lst_year", "kind": "variable", "doc": "<p>list of time intervals</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.shape", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.shape", "kind": "variable", "doc": "<p>the shape of the 2D maps</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.TMGLOB", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.TMGLOB", "kind": "variable", "doc": "<p>the mean surface temperature</p>\n"}, {"fullname": "py_artecs.artecs_map.artecs_map.keys", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.keys", "kind": "function", "doc": "<p>returns the list of quantities in the map</p>\n\n<p>Keywords: </p>\n\n<blockquote>\n  <p><code>maps</code> (default False), if True returns just the list of of elements which are 2D maps</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">maps</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.artecs_map.artecs_map.has_key", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.has_key", "kind": "function", "doc": "<p>True if required <code>key</code> is in the map</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.artecs_map.artecs_map.parameter", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.parameter", "kind": "function", "doc": "<p>returns a parameter from the fits file from its `key'</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.artecs_map.artecs_map.description", "modulename": "py_artecs.artecs_map", "qualname": "artecs_map.description", "kind": "function", "doc": "<p>returns the description of a parameter in the fits file from its `key'</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb", "modulename": "py_artecs.modelDb", "kind": "module", "doc": "<p><strong>DEPRECATED</strong></p>\n"}, {"fullname": "py_artecs.modelDb.modelDb", "modulename": "py_artecs.modelDb", "qualname": "modelDb", "kind": "class", "doc": "<p><strong>DEPRECATED</strong> </p>\n\n<p>Class to handle a local version of the ARTECS DB.</p>\n\n<p>It takes in input a csv file generated from a query of ARTECS and saved in csv format.</p>\n\n<p>See the example in the introductory page.</p>\n\n<p>This module is kept for compatibility with early releases of py_artecs, but it is not maintained so its use is DEPRECATED.</p>\n"}, {"fullname": "py_artecs.modelDb.modelDb.__init__", "modulename": "py_artecs.modelDb", "qualname": "modelDb.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">project_name</span>,</span><span class=\"param\">\t<span class=\"n\">project_path</span>,</span><span class=\"param\">\t<span class=\"n\">csv_name</span>,</span><span class=\"param\">\t<span class=\"n\">Verbose</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">csv_sep</span><span class=\"o\">=</span><span class=\"s1\">&#39;!&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">csv_comment</span><span class=\"o\">=</span><span class=\"s1\">&#39;#&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">csv_index_col</span><span class=\"o\">=</span><span class=\"s1\">&#39;index&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">figures_path</span><span class=\"o\">=</span><span class=\"s1\">&#39;png&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">filterBad</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">new</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">query</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, {"fullname": "py_artecs.modelDb.modelDb.to_csv", "modulename": "py_artecs.modelDb", "qualname": "modelDb.to_csv", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">outFile</span>, </span><span class=\"param\"><span class=\"n\">COMMENT</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.reset", "modulename": "py_artecs.modelDb", "qualname": "modelDb.reset", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.copy", "modulename": "py_artecs.modelDb", "qualname": "modelDb.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.unique_values", "modulename": "py_artecs.modelDb", "qualname": "modelDb.unique_values", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.list_unique_values", "modulename": "py_artecs.modelDb", "qualname": "modelDb.list_unique_values", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.classification_indexes", "modulename": "py_artecs.modelDb", "qualname": "modelDb.classification_indexes", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">arg</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">karg</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.show_classTable", "modulename": "py_artecs.modelDb", "qualname": "modelDb.show_classTable", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.unique", "modulename": "py_artecs.modelDb", "qualname": "modelDb.unique", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.sort", "modulename": "py_artecs.modelDb", "qualname": "modelDb.sort", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sort_by</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.sorted_query", "modulename": "py_artecs.modelDb", "qualname": "modelDb.sorted_query", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sort_by</span>, </span><span class=\"param\"><span class=\"n\">qstr</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.query", "modulename": "py_artecs.modelDb", "qualname": "modelDb.query", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">qstr</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.select_by_loc", "modulename": "py_artecs.modelDb", "qualname": "modelDb.select_by_loc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">loc_argument</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.select_by_iloc", "modulename": "py_artecs.modelDb", "qualname": "modelDb.select_by_iloc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iloc_argument</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.classification_string2numeric", "modulename": "py_artecs.modelDb", "qualname": "modelDb.classification_string2numeric", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">strg</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.calc_iclass", "modulename": "py_artecs.modelDb", "qualname": "modelDb.calc_iclass", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">string_classification_array</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.keys", "modulename": "py_artecs.modelDb", "qualname": "modelDb.keys", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.has_key", "modulename": "py_artecs.modelDb", "qualname": "modelDb.has_key", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">this</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.reset_plot_status", "modulename": "py_artecs.modelDb", "qualname": "modelDb.reset_plot_status", "kind": "function", "doc": "<p>resets the self._last_plot dictionary where handles from the last plot generated are stored</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.plot2", "modulename": "py_artecs.modelDb", "qualname": "modelDb.plot2", "kind": "function", "doc": "<p>creates a 2 axis plot, the handles for the plot objects are stored in self._last_plot</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">x</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"o\">=</span><span class=\"s1\">&#39;MolecularDepth&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">ylog</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">xlog</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">newfig</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">legend_loc</span><span class=\"o\">=</span><span class=\"mi\">3</span>,</span><span class=\"param\">\t<span class=\"n\">xylim</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">savefig</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">one2one_line</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.set_iceTOT_threshold", "modulename": "py_artecs.modelDb", "qualname": "modelDb.set_iceTOT_threshold", "kind": "function", "doc": "<p>set iceTOT_threshold : the ice coverage over which the planet is considered a snowball\nsuggested values 0.95 or 0.99</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iceTOT_threshold</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.flag_class_warm", "modulename": "py_artecs.modelDb", "qualname": "modelDb.flag_class_warm", "kind": "function", "doc": "<p>returns Murante's classifications for warm calculated from scratch\niceTOT_threshold is the ice coverage over which the planet is considered a snowball\nsuggested values 0.95 or 0.99</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.flag_class_warm_hot", "modulename": "py_artecs.modelDb", "qualname": "modelDb.flag_class_warm_hot", "kind": "function", "doc": "<p>returns Murante's classifications for warm_hot calculated from scratch\niceTOT_threshold is the ice coverage over which the planet is considered a snowball\nsuggested values 0.95 or 0.99</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.flag_class_snowball", "modulename": "py_artecs.modelDb", "qualname": "modelDb.flag_class_snowball", "kind": "function", "doc": "<p>returns Murante's classifications for warm_hot calculated from scratch\niceTOT_threshold is the ice coverage over which the planet is considered a snowball\nsuggested values 0.95 or 0.99</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.modelDb.modelDb.flag_class_waterbelt", "modulename": "py_artecs.modelDb", "qualname": "modelDb.flag_class_waterbelt", "kind": "function", "doc": "<p>returns Murante's classifications for warm_hot calculated from scratch\niceTOT_threshold is the ice coverage over which the planet is considered a snowball\nsuggested values 0.95 or 0.99</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap", "modulename": "py_artecs.tap", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "py_artecs.tap.EXOP_TAP", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP", "kind": "class", "doc": "<p></p>\n"}, {"fullname": "py_artecs.tap.EXOP_TAP.__init__", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tap_url</span><span class=\"o\">=</span><span class=\"s1\">&#39;http://archives.ia2.inaf.it/vo/tap/exo&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">table_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;exo.EXO&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">temporary_files_path</span><span class=\"o\">=</span><span class=\"s1\">&#39;/tmp&#39;</span></span>)</span>"}, {"fullname": "py_artecs.tap.EXOP_TAP.keys", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.keys", "kind": "function", "doc": "<p>list of fields in the database</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.has_key", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.has_key", "kind": "function", "doc": "<p>has_key</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">this</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.success", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.success", "kind": "function", "doc": "<p>returns True if last search was successfull</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.clean", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.clean", "kind": "function", "doc": "<p>cleans information from last search</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.adql_search", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.adql_search", "kind": "function", "doc": "<p>search on database using ADQL string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">adql_string</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.search_string", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.search_string", "kind": "function", "doc": "<p>creates a properly formatted adql query_string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">SELECTION</span>, </span><span class=\"param\"><span class=\"n\">TOP</span>, </span><span class=\"param\"><span class=\"n\">FIELDS</span>, </span><span class=\"param\"><span class=\"n\">WHERE</span>, </span><span class=\"param\"><span class=\"n\">SORT</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.search", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.search", "kind": "function", "doc": "<p>download a table from the database\nsearch('') or search(WHERE='') returns all the data in the database</p>\n\n<p>the table can be returned as :\n   pandas dataframe (default)\n   astropy table (as_astropy = True)\n   votable (as_votable=True)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">WHERE</span>,</span><span class=\"param\">\t<span class=\"n\">SELECTION</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">FIELDS</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">TOP</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">SORT</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">as_astropy</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">as_votable</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.get_map", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.get_map", "kind": "function", "doc": "<p>gets a map</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_URL</span>, </span><span class=\"param\"><span class=\"n\">outfile</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.download_map", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.download_map", "kind": "function", "doc": "<p>download the fits file corresponding at a given URL\nif outfile is not specified the fits file name from the URL is used\nif path is not specified the current file is stored in the current path</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">URL</span>, </span><span class=\"param\"><span class=\"n\">outfile</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "py_artecs.tap.EXOP_TAP.EXPLAIN", "modulename": "py_artecs.tap", "qualname": "EXOP_TAP.EXPLAIN", "kind": "function", "doc": "<p>print a short introduction on the query language</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();