__DESCRIPTION__="""

vectorized elemental rotations

M.Maris - V0.0 - 2023 Aug 05 -


"""
import numpy as np

# 3D versors X, Y, Z
vAX3D = np.array([1,0,0])
vAY3D = np.array([0,1,0])
vAZ3D = np.array([0,0,1])


def _vectorized_rotation_base_matrix(self,Angle) :
   """
commodity function to define a base for a vectorized rotation matrix, returns the components 
I, c, s of a list of elemental 3D rotation matrices with 

   I.shape=(N,3,3),
   c.shape=N, 
   s.shape=N.

with N = 1 is Angle is scalar, otherwise N=len(Angle)
   
   Parameters
   ----------
      :Angle: scalar or array of rotation angle(s) in radiants
   """
   _angle=np.array([Angle]) if np.isscalar(Angle) else Angle
   c=np.cos(_angle)
   s=np.sin(_angle)
   I=np.zeros([len(_angle),3,3])
   I[:,0,0]=1
   I[:,1,1]=1
   I[:,2,2]=1
   return I,c,s

def vERotX(Angle) :
   """Vectorized elemental rotations about X axis
   
   returns a list of elemental 3D rotation matrices with shape (N,3,3)
   with N = 1 if Angle is scalar, otherwise N=len(Angle)
   
   Parameters
   ----------
      :Angle: scalar or array of rotation angle(s) in radiants
   """
   R,c,s=_vectorized_rotation_base_matrix(Angle)
   R[:,1,1]= c
   R[:,1,2]=-s
   R[:,2,1]= s
   R[:,2,2]= c
   return R

def vERotY(Angle) :
   """Vectorized elemental rotations about Y axis
   
   returns a list of elemental 3D rotation matrices with shape (N,3,3)
   with N = 1 if Angle is scalar, otherwise N=len(Angle)
   
   Parameters
   ----------
      :Angle: scalar or array of rotation angle(s) in radiants
   """
   R,c,s=_vectorized_rotation_base_matrix(Angle)
   R[:,0,0]= c
   R[:,0,2]= s
   R[:,2,0]=-s
   R[:,2,2]= c
   return R

def vERotZ(Angle) :
   """Vectorized elemental rotations about Z axis
   
   returns a list of elemental 3D rotation matrices with shape (N,3,3)
   with N = 1 if Angle is scalar, otherwise N=len(Angle)
   
   Parameters
   ----------
      :Angle: scalar or array of rotation angle(s) in radiants
   """
   R,c,s=_vectorized_rotation_base_matrix(Angle)
   R[:,0,0]= c
   R[:,0,1]=-s
   R[:,1,0]= s
   R[:,1,1]= c
   return R

