import numpy as np

class intervalls() :
   """ A class to handle intervalls. 
   
   Usage:
      v = [0,1,2,3,5,6,7]
      ITV = intervalls(v)
      
      for i in ITV :
         print(i)
         
      will result in printing
         (0,3)
         (5,7)
         
      print ITV[0]
      
      will result in printing
         (0,3)
   """
   def __init__(self,v,dv=1) :
      self._current = -1
      if v == None :
         self.inf=[]
         self.sup=[]
      else :
         if len(v) == 0 :
            self.inf=[]
            self.sup=[]
         else :
            self.inf = [v[0]]
            self.sup = []
            vlast = v[0]
            for i in range(1,len(v)) :
               if v[i]-vlast <= dv :
                  vlast = v[i]
               else :
                  self.sup.append(vlast)
                  self.inf.append(v[i])
                  vlast = v[i]
            self.sup.append(v[len(v)-1])
            self.inf = np.array(self.inf)
            self.sup = np.array(self.sup)
   def __len__(self) :
      return len(self.inf)
   def __iter__(self) :
      return self
   def __getitem__(self,idx) :
      if len(self.inf) < 0 :
         raise NameError("Empty Intervalls")
      return (self.inf[idx], self.sup[idx])
   def next(self) :
      if self._current >= len(self.inf)-1 :
         self._current = -1
         raise StopIteration
      else :
         self._current += 1
         return (self.inf[self._current], self.sup[self._current])
   def arange(self,idx) :
      import numpy as np 
      if len(self.inf) < 0 :
         raise NameError("Empty Intervalls")
      return np.arange(self.inf[idx], self.sup[idx]+1)

def _TEST_intervalls() :
   v = [0,1,2,3,5,6,7]
   ITV = intervalls(v)
   for i in ITV :
      print(i)
   print (ITV[1])
#_TEST_intervalls()

