__DESCRIPTION__=""" basic profiling utilities, for more complex profiling use python3 cProfile """

class timer() :
    """class to handle a simple timer (uses time.time() differences)
       Attributes:
          tic     : the starting unix time at instantiation of .start() after .stop() the elapsed seconds
          name    : the timer name
          running : true if the timer is running
          start() : restarst the timer
          stop()  : stops the timer
    """
    @property
    def tic(self) :
        return self._tic
    @property
    def name(self) :
        return self._name
    @property
    def running(self) :
       return self._running
    def __init__(self,name='') :
        self._name=name
        self._running=False
        self.start()
    def __repr__(self):
        if self._name == '' :
           return '('+str(self._tic)+' s)'
        else :
           return '('+self._name+'='+str(self._tic)+' s)'
    def start(self) :
        """ starts the timer """
        import time
        self._running=True
        self._tic=time.time()
    def stop(self) :
        """ stops the timer
        Returns:
            elapsed seconds after start
        """
        import time
        if self._running :
           self._tic=time.time()-self._tic
        self._running=False
        return self._tic
    def reset(self) :
        """ stops and resets a timer """
        self._running=False
        self._tic=0.

class timerDict() :
   """ class to handle a dictionary of timers.

      Each object of a timerDict is a single istantiation of a timer class

      Timers=timerDict()

      to create a new timer and starting it
         Timers.new('timer1')

      to poll a timer
         print(Timers['timer1'])

      to start a timer
         Timers['timer1'].start()

      to stop a timer
         Timers['timer1'].stop()

      Attributes :
         new()   : instatiates a new timer
         keys()  : list of timer names
         pop()   : removes a timer from the list
         reset() : reset all timers
         start() : start all timers
         stop()  : stop all timers
         sum()   : total of all timers
   """
   def __init__(self,redefineExistingTimer=True) :
      self._T={}
      self._redefineExistingTimer=redefineExistingTimer
   #
   def __getitem__(self,this) :
      if not this in self._T.keys() :
         raise Exception('Error, %s not in timer dictionary','')
      return self._T[this]
   #
   def __len__(self) :
      return len(self._T.keys())
   #
   def __str__(self) :
      """list of timer values as a string in the form <name>=<value>, each timer separed by '\n'"""
      if len(self) == 0 :
         return ''
      return '\n'.join([k+'='+str(self[this])])
   #
   def keys(self) :
      """ returns list of timers """
      return self._T.keys()
   #
   @property
   def redefineExistingTimer(self) :
      """ if True it is possible to redefine an existing timer as a way to restart """
      return self._redefineExistingTimer
   #
   def new(self,name) :
      """ instatiates a new timer

      If timer exists:
         if redefineExistingTimer=True at creation of the list the timer is restarted, otherwise an exception is issued

         Argument:
            name : name of the timer

      """
      if name in self._T.keys() :
         if not self._redefineExistingTimer :
            raise Exception('Error, timer %s already exists and list has redefineExistingTimer==False','')
         self._T[name].start()
      else :
         self._T[name]=timer(name)
   #
   def pop(self,name) :
      """ removes timer of given name """
      if not name in self._T.keys() :
         raise Exception('Error, %s not in timer dictionary','')
      return self._T.pop(name)
   #
   def reset(self,name='') :
      if name != '' :
         self[name].start()
      else :
         for k in self.keys() :
            self[k].stop()
            self[k].reset()
   #
   def start(self,name='') :
      if name != '' :
         self[name].start()
      else :
         for k in self.keys() :
            self[k].start()
   #
   def stop(self,name='') :
      if name != '' :
         self[name].start()
      else :
         for k in self.keys() :
            self[k].start()
   #
   def sum(self) :
      """ total time in timers """
      if len(self) == 0 : return 0
      acc=0
      for k in self.keys() :
         if not self[k].running :
            acc+=self[k].tic
      return acc
   #
   def number_running(self) :
      """ number of running timers """
      if len(self) == 0 : return 0
      acc=0
      for k in self.keys() :
         acc+=1*self[k].running
      return acc
