""" periodic stats is a collection of tools for statistics over periodic quantities """

import numpy as np

def periodic_stats(alpha,deg=False) :
    """ statistics of a periodic alpha (radiants)
    
    If alpha is a vector of angles (radiants) find the average number and the std deviation avoiding the problem of the switch between -180,180 or 360 and 0
    
    example: alpha=np.array([-180,180]) 
    
    """
    u=np.cos(alpha)
    v=np.sin(alpha)
    #
    rr=np.array([np.nanmean(u),np.nanmean(v)])
    rr=rr/rr.dot(rr)**0.5
    #
    up=rr[0]*u+rr[1]*v ;
    vp=-rr[1]*u+rr[0]*v
    #
    ap=np.rad2deg(np.arctan2(vp,up).std())
    #
    return np.arctan2(rr[1],rr[0]), np.nanvar(np.arctan2(vp,up))**0.5

if __name__=='__main__' :
   alpha_deg=np.arange(350,371)
   print(np.deg2rad(alpha-360).mean(),np.deg2rad(alpha-360).std())
   print(periodic_stats(np.deg2rad(alpha)))    
