__DESCRIPTION__="""
"""
class pyBlocks :
   """support class to list products in the help file"""
   def __init__(self) :
      from collections import OrderedDict
      self.M=OrderedDict()
      self.N=0
      self._cod=[]
      self._dsc=[]
      self._pdf=[]
      self._tab=[]
      self._deprecated=[]
      self._ack=False
   #
   def __len__(self) :
      return self.N
   #
   def keys(self) :
      return self.M.keys()
   #
   def description(self,code) :
      return self(code)[0]
   #
   def pdf(self,code) :
      return self(code)[1]
   #
   def tab(self,code) :
      return self(code)[2]
   #
   def __call__(self,*arg,**karg) :
      """
      __call__(code) : returns description
      __call__(iPlot,code,dsc,[pdf],[tab]) : returns iPlot==code and stores description
      """
      #from collections import OrderedDict
      if len(arg) == 1 :
         _k=self.M[arg[0]]
         return self._dsc[_k],self._pdf[_k],self._tab[_k]
      #
      self.N+=1
      iPlot=arg[0]
      _c=arg[1]
      self._cod.append(_c)
      self._dsc.append(arg[2])
      self._pdf.append(arg[3] if len(arg)>=4 else '')
      self._tab.append(arg[4] if len(arg)>=5 else '')
      self.M[_c]=self.N-1

      #
      if 'deprecated' in karg :
         self._deprecated.append(karg['deprecated']==True)
      else :
         self._deprecated.append(False)

      # if another code have been already acknowledged does nothing
      if self._ack : return False

      self._ack=_c==iPlot

      if self._ack :
         print("\n*************************************\n",_c," : ",arg[2])
      return self._ack
   #
   def acknowledged(self) : return self._ack
   #
   def __str__(self) :
      import numpy as np
      if len(self) == 0 : return ''
      l=[]
      idx=np.argsort(self._cod)
      for k in idx :
         l.append('%5d : %s%s'%(self._cod[k],self._dsc[k],' <<DEPRECATED>>' if self._deprecated[k] else '' ))
      return '\n'.join(l)
