def nearly_even_split(idx,nblocks,strict=False) :
    """ splits a list of indexes idx into nblocks
    if len(idx) can not be integer divided into nblocks
    a further, shorter block is appended to accomodate the remainder samples

    keyword: strict
             if True the array the remainder is appended at the last block

    Example:
      x=np.arange(113)
      out=nearly_even_split(x,7)
      print(len(out))
      > 8
      # this is a test to check proper partition
      print(abs(np.concatenate(out)-x).ptp())
      > 0
      print(out)
      [array([ 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15]),
       array([16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31]),
       array([32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47]),
       array([48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63]),
       array([64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79]),
       array([80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95]),
       array([ 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
               109, 110, 111]),
       array([112])]

    V 1.0 - 2023 Jan 12 - M.Maris
    """
    #
    import numpy as np
    #
    rembloc=int(np.mod(len(idx),nblocks))

    if strict and rembloc > 0 and nblocks>1:
        rembloc=np.mod(len(idx),nblocks-1)
        dblock=len(idx)//(nblocks-1)
        EVEN=dblock*(nblocks-1)
        out=list(np.split(idx[:EVEN],(nblocks-1)))
        if rembloc > 0 :
            out.append(idx[EVEN:])
    else :
        dblock=len(idx)//nblocks
        EVEN=dblock*nblocks
        out=list(np.split(idx[:EVEN],nblocks))
        if rembloc > 0 :
            out.append(idx[EVEN:])
    return out
