class ImshowXT :
   """ class to handle an improved version of plt.imshow """
   def __init__(self,matr,x_values,y_values,**kwargs) :
      """ matr = the matrix to show,
            x_values = the values on the x axis,
            y_values, the values on the y axis
            kwarg = kwargs for plt.imshow
      """
      from matplotlib import pyplot as plt
      self._im=plt.imshow(matr,**kwargs)
      self._xv=x_values
      self._yv=y_values
   def set_xaxis(self,major_values,major_format,major_at_nearestPixel=False) :
      """ format the x axis for a give list of major tick values and a formatting string 
          major_at_nearestPixel = True places each major_value at the nearest pixel (default False)
      """
      from matplotlib import pyplot as plt
      import numpy as np
      from scipy.interpolate import interp1d
      self._mxv=major_values
      self._mxf=major_format
      #
      v=self._xv
      t1=np.arange(len(v))
      #
      if major_at_nearestPixel :
         t=np.array([np.argmin(np.abs(k-v)) for k in major_values])
      else :
         itp=interp1d(v,t1,fill_value='extrapolate')
         t=itp(major_values)
      #
      plt.xticks(t,np.interp(t,t1,v))
      tt=plt.gca().get_xticklabels()
      for ik in range(len(tt))  :
         o=float(tt[ik].get_text())
         o1=major_format%o
         tt[ik].set_text(o1)
      plt.gca().set_xticklabels(tt)
   def set_yaxis(self,major_values,major_format,major_at_nearestPixel=False) :
      """ format the y axis for a give list of major tick values and a formatting string 
          major_at_nearestPixel = True places each major_value at the nearest pixel (default False)
      """
      from matplotlib import pyplot as plt
      import numpy as np
      from scipy.interpolate import interp1d
      self._myv=major_values
      self._myf=major_format
      #
      v=self._yv
      t1=np.arange(len(v))
      #
      if major_at_nearestPixel :
         t=np.array([np.argmin(np.abs(k-v)) for k in major_values])
      else :
         itp=interp1d(v,t1,fill_value='extrapolate')
         t=itp(major_values)
      #
      plt.yticks(t,np.interp(t,t1,v))
      tt=plt.gca().get_yticklabels()
      for ik in range(len(tt))  :
         o=float(tt[ik].get_text())
         o1=major_format%o
         tt[ik].set_text(o1)
      plt.gca().set_yticklabels(tt)
   def colorbar(self,**karg) :
      """ add a color bar """
      from matplotlib import pyplot as plt
      plt.colorbar(**karg)

def odot(x,y,color=['yellow','red'],markersize=[30,10],scale=1.,zorder=None,mew=[4,0]) :
   """ draw an odot"""
   from matplotlib import pyplot as plt
   a=plt.plot(x,y,'o',color=color[0],markersize=markersize[0]*scale,mew=mew[0],markeredgecolor=color[1])
   b=plt.plot(x,y,'o',color=color[1],markersize=markersize[1]*scale,mew=mew[1])
   if type(zorder) == type(1) :
      a[0].set_zorder(zorder)
      b[0].set_zorder(zorder+1)
   return (a,b)

def ocirc(x,y,color=['white','black'],markersize=[30],scale=1.,zorder=None,mew=[4,0]) :
   """ draw an odot"""
   from matplotlib import pyplot as plt
   a=plt.plot(x,y,'o',color=color[0],markersize=markersize[0]*scale,mew=mew[0],markeredgecolor=color[1])
   #b=plt.plot(x,y,'o',color=color[1],markersize=markersize[1]*scale,mew=mew[1])
   if type(zorder) == type(1) :
      a[0].set_zorder(zorder)
      #b[0].set_zorder(zorder+1)
   return a

def curveXY2patch(x,y,returnVectors=False,closed=True,draw=True, ax=None,color=None) :
   """ Converts a curve in a patch """
   import numpy as np
   from matplotlib import pyplot as plt
   from matplotlib.patches import Polygon
   from matplotlib.collections import PatchCollection
   from matplotlib.pyplot import gca
   xy=np.array([x,y]).T
   if returnVectors : 
      return xy
   pol=Polygon(xy,closed=closed,facecolor=color,edgecolor=color)
   if draw:
       if ax is not None:
           return ax.add_collection(PatchCollection([pol]))
       else:
           return plt.gca().add_collection(PatchCollection([pol]))

def curves2xy(Cup,Cdown,closed=True) :
   """  converts an up curve and a down curve into a list of points to generate a partch

        Cup, Cdown = curves = [X,Y]
        assumed that Cup, Cdown have increasing X

        the composed curve [X,Y] is oriented anticlockwise sense:
            up: increasing X
            down: decreasing X

        closed = True, the curve is closed, otherwise is left open

    Example:
        X,Y=curves2xy([np.arange(5),np.arange(5)+10],[np.arange(5),-np.arange(5)])
        plt.plot(X,Y)
   """
   import numpy as np
   idxU=np.argsort(Cup[0])
   idxD=np.argsort(Cdown[0])
   idxD=np.array([idxD[k] for k in range(len(idxD)-1,-1,-1)],dtype=int)
   idxO=np.array([0],dtype=int) if closed else []
   X=np.concatenate([Cup[0][idxU],Cdown[0][idxD],Cup[0][idxO]])
   Y=np.concatenate([Cup[1][idxU],Cdown[1][idxD],Cup[1][idxO]])
   return X,Y

class _SaveFig :
   class __history_fig :
      def __init__(self) :
         self.clear()
      def keys(self) :
         return self._d.keys()
      def clear(self) :
         self._d={}
      def __getitem__(self,this) :
         if not this in self.keys() :
            return []
         return self._d[this]
      def __setitem__(self,this,that) :
         if not this in self.keys() :
            self._d[this]=[]
         self._d[this].append(that)
      def append(self,this) :
         xt=this.split('.')[-1]
         self[xt]=this
   #
   def __init__(self) :
      self.set_abilited(False)
      self.set_fig2paper(False)
      self.set_path('/tmp')
      self.set_paperpath('/tmp')
      self.set_png(False)
      self.set_pdf(True)
      self.set_extensions(['pdf'])
      self.history=self.__history_fig()
   def set_abilited(self,v) :
      self.abilited=(v==True) or (v==1)
   def set_path(self,v) :
      self.path=v
   def set_paperpath(self,v) :
      self.paperpath=v
   def set_fig2paper(self,v) :
      self.fig2paper=(v==True) or (v==1)
   def set_png(self,v) :
      self.png=v
   def set_pdf(self,v) :
      self.pdf=v
   def set_extensions(self,v) :
      self.extensions=[k for k in v]
   def __str__(self) :
      a='Abilited' if self.abilited else 'Not Abilited'
      return 'SaveFig '+a+', path='+self.path
   def __call__(self,fname,pdf=True,png=False,extensions=None) :
      import numpy as np
      import os
      from matplotlib import pyplot as plt
      #
      #creates list of extensions
      ext=[]
      if self.pdf : ext.append('pdf')
      if self.png : ext.append('png')
      if pdf : ext.append('pdf')
      if png : ext.append('png')
      if type(extensions) in [type([]),type(())] :
         for k in extl :ext.append(k)
      else :
         for k in self.extensions :ext.append(k)
      #
      if self.abilited :
         fig=plt.gcf()
         for xt in np.unique(ext) :
            out1=self.path+'/'+xt+'/'+fname
            out=out1+'.'+xt
            print ("Saving in ",out)
            plt.savefig(out,dpi=fig.get_dpi())
            #
            self.history.append(out)
            #
            if self.fig2paper and type(self.paperpath)==type("") :
               command='cp -v '+out+' '+self.paperpath
               print (command)
               print (os.system(command))
   def create_animated_gif(self,xt='png',delay=100,loop=0,out=None,execute=True) :
      import os
      if len(self.history[xt]) == 0 :
         print('No figures with %s extension'%xt)
         return
      command='convert '
      command+=' -loop '+str(loop)
      command+=' -delay '+str(delay)
      for k in self.history[xt] :
         k1=k.replace('(','\(')
         k1=k1.replace(')','\)')
         command+=' '+k1
      if out is None :
         oname=self.history[xt][0].split('=')[0]
         oname='/gif/'.join(oname.split('/'+xt+'/'))
      else :
         oname=out
      if not '.gif' in oname :
         oname+='.gif'
      oname=oname.replace('(','\(')
      oname=oname.replace(')','\)')
      command+=' '+oname
      if execute :
         print(command)
         os.system(command)
         return oname
      return command
SaveFig=_SaveFig()

class StandardFig() :
    """ class to handle a Standardized Figure layout """
    @property 
    def activated(self) :
       """ True if savefig activated """
       return self._activated
    @activated.setter
    def activated(self,this) :
       self._activated=(this==True)
    @property
    def setting(self) :
       """ name of the setting (set4slides ... )"""
       return self._setting
    @property
    def figprefix(self) :
       """ Figure prefix """
       return self._figprefix
    @figprefix.setter
    def figprefix(self,this) :
       if this is None :
          self._figprefix=""
       else :
         self._figprefix=str(this).strip()
    @property
    def figpath(self) :
       """ Figure path """
       return self._figpath
    @figpath.setter
    def figpath(self,this) :
        # removes the trailing /
        ll=this.strip().split('/')
        while ((ll[-1] if len(ll)>0 else '') =='' and len(ll)>0) : ll=ll[:-1]
        if len(ll)==0 :
           self._figpath='.'
        else :
           self._figpath='/'.join(ll)
        if self.split_path :
           self._figpath_pdf=self._figpath+'/pdf'
           self._figpath_png=self._figpath+'/png'
        else :
           self._figpath_pdf=self._figpath+''
           self._figpath_png=self._figpath+''
    @property 
    def figratio(self) :
       """ fig ratio """
       return self._figratio
    @figratio.setter
    def figratio(self,this) :
       self._figratio=this
       x=18 if self.figside == None else self.figside
       y=(2/3 if self._figratio is None else self._figratio)
       self._figsize=(x,x*y)
    @property 
    def figside(self) :
       """ fig side """
       return self._figside
    @figside.setter
    def figside(self,this) :
        self._figside=this
        x=18 if self.figside == None else self.figside
        y=(2/3 if self._figratio is None else self._figratio)
        self._figsize=(x,x*y)
    @property 
    def figsize(self) :
       """ fig size """
       return self._figsize
    @figsize.setter 
    def figsize(self,this) :
       self._figsize=this
       self._figratio=this[1]/this[0]
       self._figside=this[0]
    #
    @property 
    def split_path(self) :
       """ if split_path==True a separed subdir for png and pdf is created and used"""
       return self._split_path
    @split_path.setter 
    def split_path_setter(self,this) :
       self._split_path=(this==True)
    #
    @property 
    def fig(self) :
       """ handle for fig """
       try :
          return self._handle['fig']
       except :
          return None
    #
    @property 
    def handle(self) :
       """ dictionary of graphic objects handles """
       return self._handle
    #
    def __init__(self,figpath=None,figside=16,figratio=2/3,Creator='', Copyright='',Author='',split_path=False,figprefix="") :
        """
   Creates a StandardFig object
   
   :Keywords: 
      figprefix  = prefix for the figure ("")
      figpath    = path for the figure (None)
      figside    = horizontal side of the figure [in] (16)
      figratio   = V/H ratio of figure (2/3)
      split_path = if True the path is splitted (False)
      Creator    = creator 
      Author     = Author Name 
      Copyright  = copyright string
   
   To have the handles to the figure components use the .handle dictionary.
        """
        self.free_metadata()
        #
        self._activated=True
        #
        self._setting=None
        #
        self._figprefix=""
        self._figpath=None
        self._figpath_pdf=None
        self._figpath_png=None
        #
        self._split_path=split_path
        #
        self._figratio=figratio
        self.figside=figside
        #
        self.figprefix=figprefix
        #
        if not figpath is None :
           self.figpath=figpath 
        #
        self.Author=Author
        self.Creator=Creator
        self.Copyright=Copyright
        #
        # list of handles for various objects
        self._handle={}
        #
        self.setfonts4paper()
        #
        self.legend_framealpha=None
    def make_figpath(self,figpath) :
       """ Makes figpath """
       import os
       self.figpath=figpath
       if self._figpath!='.' :
            os.system('mkdir -p '+self._figpath)
            os.system('mkdir -p '+self._figpath_pdf)
            os.system('mkdir -p '+self._figpath_png)
    def setfonts4paper(self) :
       """sets figures with proportions for paper"""
       self._setting="set4paper"
       self.fontsize_xylabels=18
       self.fontsize_ticks=16
       self.fontsize_labels=18
       self.fontsize_title=18
       self.fontsize_legend=18
       self.fontsize_legend_title=18
    def setfonts4slides(self) :
       """sets figures with proportions for 16:9 slides"""
       self._setting="set4slides"
       self.fontsize_xylabels=32
       self.fontsize_ticks=28
       self.fontsize_labels=self.fontsize_xylabels
       self.fontsize_title=32
       self.fontsize_legend=self.fontsize_xylabels
       self.fontsize_legend_title=self.fontsize_xylabels
    def copy(self) :
        import copy
        return self.deepcopy(self)
    def __call__(self,squared=False) :
       return self.new(squared=squared)
    def new(self,squared=False) :
        from matplotlib import pyplot as plt
        self._handle={}
        if squared :
            self._handle['fig']=plt.figure(figsize=(self.figside,self.figside));
        else :
            self._handle['fig']=plt.figure(figsize=self.figsize);
        self.fig.canvas.toolbar_visible = True
        self.fig.canvas.header_visible = False
        self.fig.canvas.resizable = True
        return self.fig
    def legend(self,ncol=1,loc=1,title='',fontsize=None,ax=None,title_fontsize=None,LISTP=None,legend_framealpha=None) :
        from matplotlib import pyplot as plt
        fsl=self.fontsize_legend if fontsize is None else fontsize
        fslt=self.fontsize_legend_title if title_fontsize is None else title_fontsize
        falpha=self.legend_framealpha if legend_framealpha is None else legend_framealpha
        self.ax_legend=None 
        ax1=plt.gca() if ax==None else ax
        #
        if LISTP==None :
           self._handle['legend']=ax1.legend(ncol=ncol,loc=loc,fontsize=fsl,title=title,title_fontsize=fslt)
           return self._handle['legend']
        #
        lns = LISTP[0]
        for ik in range(len(LISTP)) :
            if ik == 0 :
                lns=LISTP[0]
            else :
                lns += LISTP[ik]
        labs = [l.get_label() for l in lns]
        self._handle['legend']=ax1.legend(lns, labs,ncol=ncol,loc=loc,fontsize=self.fontsize_legend if fontsize is None else fontsize,title=title,title_fontsize=fslt)
        return self._handle['legend']
    def title(self,txt,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        lk='title'
        fs=self.fontsize_title if fontsize is None else fontsize
        self._handle[lk]=plt.title(txt,fontsize=fs)
        if not color is None :
           self._handle[lk].set_color(color)
        return self._handle[lk]
    def suptitle(self,txt,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        lk='suptitle'
        fs=self.fontsize_title if fontsize is None else fontsize
        self._handle[lk]=plt.suptitle(txt,fontsize=fs)
        if not color is None :
           self._handle[lk].set_color(color)
        return self._handle[lk]
    def xlabel(self,txt,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        lk='xlabel'
        fs=self.fontsize_xylabels if fontsize is None else fontsize
        self._handle[lk]=plt.xlabel(txt,fontsize=fs)
        if not color is None :
           self._handle[lk].set_color(color)
        return self._handle[lk]
    def ylabel(self,txt,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        lk='ylabel'
        fs=self.fontsize_xylabels if fontsize is None else fontsize
        self._handle[lk]=plt.ylabel(txt,fontsize=fs)
        if not color is None :
           self._handle[lk].set_color(color)
        return self._handle[lk]
    def XTICKS(self,ax=None,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        fs=self.fontsize_ticks if fontsize is None else fontsize
        aa=plt.gca().get_xticklabels() if ax is None else ax.get_xticklabels()
        for k in aa : k.set_fontsize(fs)
        if not color is None :
           for k in aa : k.set_color(color)
    def YTICKS(self,ax=None,fontsize=None,color=None) :
        from matplotlib import pyplot as plt
        fs=self.fontsize_ticks if fontsize is None else fontsize
        aa=plt.gca().get_yticklabels() if ax is None else ax.get_yticklabels()
        for k in aa : k.set_fontsize(fs)
        if not color is None :
           for k in aa : k.set_color(color)
    def gridspec(self,nrows,ncols,**kargs) :
        """ generates a GridSpec array. See matplotlib.gridspec.GridSpec """
        import matplotlib.gridspec as gridspec
        return gridspec.GridSpec(nrows,ncols,**kargs)
    def xaxis_visible(self,visible) :
        import matplotlib.gridspec as gridspec
        plt.gca().get_xaxis().set_visible(visible)
    def yaxis_visible(self,visible) :
        import matplotlib.gridspec as gridspec
        plt.gca().get_xaxis().set_visible(visible)
    #
    # metadata PROPERTIES
    @property
    def Copyright(self) :
       return self._Copyright
    @Copyright.setter 
    def Copyright(self,this) :
       if this is None : return
       self._Copyright=str(this).strip()
    #
    @property
    def CreationDate(self) :
       import time
       self._CreationDate=time.asctime()
       return self._CreationDate
    #
    @property
    def ModDate(self) :
       import time
       self._ModDate=time.asctime()
       return self._ModDate
    #
    @property
    def Subject(self) :
       return self._Subject
    @Subject.setter
    def Subject(self,this) :
       if this is None : return
       self._Subject=str(this).strip()
    #
    @property
    def Keywords(self) :
       return self._Keywords
    @Keywords.setter
    def Keywords(self,this) :
       if this is None : return
       self._Keywords=str(this).strip()
    #
    @property
    def Author(self) :
       return self._Author
    @Author.setter
    def Author(self,this) :
       if this is None : return
       self._Author=str(this).strip()
    #
    @property
    def Creator(self) :
       return self._Creator
    @Creator.setter
    def Creator(self,this) :
       if this is None : return
       self._Creator=str(this).strip()
    #
    @property
    def WARNING(self) :
       return self._WARNING
    @WARNING.setter
    def WARNING(self,this) :
       if this is None : return
       self._WARNING=str(this).strip()
    #
    @property
    def Comment(self) :
       return self._Comment
    @Comment.setter
    def Comment(self,this) :
       if this is None : return
       self._Comment=str(this).strip()
    #
    @property
    def Disclaimer(self) :
       return self._Disclaimer
    @Comment.setter
    def Disclaimer(self,this) :
       if this is None : return
       self._Disclaimer=str(this).strip()
       
    def free_metadata(self):
      self.Title=''
      self.Subject=''
      self.Keywords=''
      self._Comment=''
      self._CreationDate=None
      self._ModDate=None
      self._Description=''
      self._WARNING=''
      self._Disclaimer=''
    #
    @property
    def pdf_metadata(self) :
       return {
           'Creator':self.Creator
          ,'Author':self.Author
          ,'Title':self.Title
          ,'Subject':self.Subject
          ,'Keywords':self.Keywords
          ,'Producer':self.Copyright
          #,'CreationDate':self.CreationDate
          #,'ModDate':self.ModDate
          }
    @property
    def png_metadata(self) :
       return {
           'Description':self.Subject
          ,'Author':self.Author
          ,'Copyright':self.Copyright
          ,'Title':self.Title
          ,'Source':'-- plot --'
          ,'Software':self.Creator
          ,'Disclaimer':self.Disclaimer
          ,'Copyright':self.Copyright
          #,'Creation Time':self.CreationDate
          ,'Warning':self.WARNING
          ,'Comment':self.Comment
          }
    def __repr__(self) :
       return str(self.__class__)+' figsize: '+str(self._figsize)+' figpath: '+self._figpath+' figprefix: '+self._figprefix+' setting: '+self._setting+' Creator: '+self.Creator+' activated: '+str(self.activated)
    def save(self,name,
              Author=None
             ,Comment=None
             ,Subject=None
             ,Disclaimer=None
             ,WARNING=None
             ,Creator=None
             ,Keywords=None
             ,Producer=None
             ) :
        from matplotlib import pyplot as plt
        if self.figpath is None :
           raise Error('figpath is None')
        #
        self.Comment=Comment
        self.Subject=Subject
        self.Disclaimer=Disclaimer
        self.WARNING=WARNING
        self.Creator=Creator
        self.Keywords=Keywords
        self.Producer=Producer
        #
        if not self.activated :
           print('SAVING OF %s not activated'%name)
           return
        #
        for k in ['png','pdf'] :
            #
            self.Title=name
            #
            metadata=None
            Name=self.figprefix+name
            if k == 'pdf' :
               metadata=self.pdf_metadata
               oname=self._figpath_pdf+'/'+Name+'.pdf'
            if k == 'png' :
               metadata=self.png_metadata
               oname=self._figpath_png+'/'+Name+'.png'
            print('savefig ',oname)
            #
            plt.savefig(oname,dpi=plt.gcf().get_dpi(),metadata=metadata)
STANDARDFIG=StandardFig()
