"""
Simple stats
"""

import numpy as np

class CumulativeOfData :
   """strucuture to handle the cumulative of 1d data"""
   @property
   def cdf(self) :
      """the cdf """
      return self._cdf
   @property
   def x(self) :
      """the score"""
      return self._x
   @property
   def N(self) :
      """the number of finite samples"""
      return self._N
   def __init__(self,X) :
      """:X: 1d array of scores"""
      idx=np.where(np.isfinite(X))
      xf=X[idx]
      self._Nin=len(X)
      self._N=len(xf)
      self._x=np.sort(X)
      self._eff=np.arange(self._N)/(self._N-1)
   def cdf(self,x) :
      """returns the cdf at a given score 
      
      :x: the score
      """
      return np.interp(x,self._x,self._eff,left=0.,right=1.)
   def percentile(self,eff) :
      """computes the percentile of samples for which x<=percentile(eff)
      
      :eff: the required percentile [0,1]
      if eff<0 the result is -infty
      if eff>0 the result is +infty
      """
      return np.interp(eff,self._eff,self._x,left=-np.infty,right=np.infty)
   
