/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.webapp.xmlconfig.UserConfiguration;
import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named
@SessionScoped
public class User implements Serializable {

    private static final long serialVersionUID = 1L;

    @Inject
    ConfigurationManager config;

    private UserConfiguration userConfiguration;

    public String getUsername() {
        return userConfiguration == null ? null : userConfiguration.getUsername();
    }

    public boolean isAdmin() {
        return userConfiguration != null && "admin".equals(userConfiguration.getRole());
    }

    public boolean isLoggedIn() {
        return userConfiguration != null;
    }

    public void login(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public String logout() {
        HttpServletRequest request = (HttpServletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (request.isRequestedSessionIdValid()) {
            request.getSession().invalidate();
        }
        return "index.xhtml?faces-redirect=true";
    }

    public UserConfiguration getUserConfiguration() {
        return userConfiguration;
    }
}
