package it.inaf.ia2.tsm.webapp;

import ari.ucidy.UCD;
import ari.ucidy.UCDParser;
import it.inaf.ia2.tsm.webapp.xmlconfig.UCDConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.core.api.scope.WindowScoped;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named("ucdEditor")
@WindowScoped
public class UCDEditor implements Serializable {

    private static final long serialVersionUID = -9117203239681234534L;

    @Inject
    private ConfigurationManager config;

    @Inject
    private User user;

    private boolean viewExisting;
    private UCDConfiguration newUCDConfiguration;
    private String invalidUCDMessage;

    public void openDialog() {
        viewExisting = true;
        newUCDConfiguration = new UCDConfiguration(user.getUsername());
        invalidUCDMessage = null;
    }

    public boolean isViewExisting() {
        return viewExisting;
    }

    public void setViewExisting(boolean viewExisting) {
        this.viewExisting = viewExisting;
        invalidUCDMessage = null;
    }

    public UCDConfiguration getNewUCDConfiguration() {
        return newUCDConfiguration;
    }

    public List<UCDConfiguration> getCustomUCDs() {
        return config.getUCDConfiguration();
    }

    public boolean isEditable(UCDConfiguration ucdConfig) {
        if (user.isAdmin()) {
            return true;
        }
        return ucdConfig.getCreator().equals(user.getUsername());
    }

    public void addUCD() throws IOException {
        invalidUCDMessage = null;

        if (newUCDConfiguration.getWord() == null || newUCDConfiguration.getWord().isEmpty()) {
            invalidUCDMessage = "Insert the UCD word";
            return;
        }

        // Check if word syntax is valid
        UCD ucd = UCDParser.parseUCD(newUCDConfiguration.getWord());

        if (ucd.size() != 1 || !ucd.getWord(0).valid) {
            invalidUCDMessage = "Invalid UCD word syntax";
            return;
        }

        if (!newUCDConfiguration.getWord().contains(":")) {
            invalidUCDMessage = "Custom UCDs must have a namespace";
            return;
        }

        boolean inserted = config.addUCD(newUCDConfiguration);
        if (!inserted) {
            invalidUCDMessage = "Specified UCD already exists";
            return;
        }

        newUCDConfiguration = new UCDConfiguration(user.getUsername());
        invalidUCDMessage = null;
    }

    public void removeUCD(UCDConfiguration ucd) {
        config.deleteUCD(ucd);
    }

    /**
     * For some reason getCurrentInstance().addMessage doesn't work inside the
     * dialog, so this field has been added for setting error message manually.
     */
    public String getInvalidUCDMessage() {
        return invalidUCDMessage;
    }
}
