/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

(function ($) {

    function fillListContainer(container, values) {
        var $container = $(container);
        $container.empty();
        for (var i = 0; i < values.length; i++) {
            $container.append('<li class="bg-info"><input type="checkbox" />' + values[i] + '</li>');
        }
    }

    function setupToggler(toggler, container) {
        var $toggler = $(toggler);
        $toggler.on('click', function (ev) {
            var $container = $(container);
            var check = $container.find('input[type="checkbox"]:checked').length
                    < $container.find('input[type="checkbox"]:not(:checked)').length;
            $container.find('input[type="checkbox"]').prop('checked', check);
            ev.preventDefault();
        });
    }

    function setupShifter(shifter, source, target) {
        var $shifter = $(shifter);
        var $target = $(target);
        $shifter.on('click', function (ev) {
            $(source).find('input[type="checkbox"]:checked').each(function (index, element) {
                $(element).prop('checked', false);
                $(element).parent().appendTo($target);
            });
            ev.preventDefault();
        });
    }

    TSM.openColumnsSorter = TSM.eventHandlerFactory(function (src, jsUpdate) {
        // Reset event handlers
        $('#columns-sorter a').off();

        var model = JSON.parse(jsUpdate);

        fillListContainer('#unsorted-columns', model.unSortedColumns);
        fillListContainer('#sorted-columns', model.sortedColumns);

        // Setting drag and sortable
        $("#unsorted-columns, #sorted-columns").sortable({
            connectWith: ".sortable"
        }).disableSelection();

        // Init toggle selection
        setupToggler('#toggle-selection-unsorted', '#unsorted-columns');
        setupToggler('#toggle-selection-sorted', '#sorted-columns');

        // Init shift buttons
        setupShifter('#shift-selection-unsorted', '#unsorted-columns', '#sorted-columns');
        setupShifter('#shift-selection-sorted', '#sorted-columns', '#unsorted-columns');

        // Showing modal
        $('#columns-sorter').modal('show');
    }, 'main:columns_sorter');

    TSM.saveColumnsOrder = function () {

        var sortedColumns = [];
        $('#sorted-columns li').each(function (index, element) {
            var columnName = $(element).text().trim();
            sortedColumns.push(columnName);
        });

        $.ajax({
            type: 'POST',
            url: TSM.getRestPath('sort-columns'),
            data: JSON.stringify(sortedColumns),
            success: function (response) {
                jsf.ajax.request('main', null, {
                    'javax.faces.behavior.event': 'action',
                    execute: '@none',
                    render: 'main:column_wrapper',
                    onevent: function (event) {
                        if (event.status === 'success') {
                            $('#columns-sorter').modal('hide');
                        }
                    }
                });
            },
            contentType: 'application/json',
            dataType: 'json'
        });
    };

})(jQuery);
