import os
from pathlib import Path
from shutil import copyfile
from time import sleep, time
from threading import Thread
from psutil import process_iter

def countAliveProcessesByScriptName(name):
    #print("countAliveProcessesByScriptName")
    count = 0
    for proc in process_iter(["cmdline"]):
        processes = [name.lower() in cmdElem for cmdElem in proc.info['cmdline'] ]
        #print("proc:",proc)
        how_many = sum( processes )
        if how_many > 0:
            print(f"[countAliveProcessesByScriptName] found process! -> {proc.info['cmdline']}")
            count += how_many
    return count

def simulateDataArrivalForSubArray(sbID, dataDir, seconds, sleepInBetween = 2):
        
    def threadFun(sbID, destDir, seconds, sleepInBetween):
        index = 0
        elapsed = 0
        while elapsed < seconds:
            t0 = time()
            sleep(sleepInBetween)
            srcDir = Path(__file__).parent.absolute()
            srcFile = srcDir.joinpath("data/dl1_LST-1.1.Run1.0.sim.fits.h5")
            destDir.mkdir(parents=True, exist_ok=True)
            destFile = destDir.joinpath(f"dl1_LST-1.1.Run1.Index{index}.sim.fits.h5")
            index+=1
            copyfile(srcFile, destFile)
            elapsed += time()-t0

    destDir = Path(dataDir).joinpath(f"datadir_{sbID}")

    if destDir.is_dir():
        for f in os.listdir(destDir):
            os.remove(os.path.join(destDir, f))  

    x = Thread(target=threadFun, args=(sbID, destDir, seconds, sleepInBetween))
    x.start()
    return x

"""
if __name__=='__main__':
    t = simulateDataArrivalForSubArray(1, "./tmp", 20)
    sleep(30)
"""