
import os, sys
import re
import shutil
import subprocess

makefile='Makefile'
Array_SubFolders=list()

#======================================================================
#Function to replace ${key} with os.environ[key]
#======================================================================

def replace_env_variables(value=None):

    if 'MC_INSTDIR' in value:
        modified_value=value.replace('${MC_INSTDIR}', os.environ['MC_INSTDIR'])
    else:

        modified_value=value

    return modified_value

#======================================================================
def Create_Makefile(FileName=None):


    with open(FileName, 'w') as file:
        # Definizione delle variabili
        file.write("CC = gcc\n")
        file.write("CFLAGS = -Wall -Ofast -I${HEADERS_GSL} -I ./include -I ${HEADERS_MPI} -I ${HEADERS_CFITSIO}\n")
        file.write("LDFLAGS = -L ${LIB_CFITSIO} -L ${LIB_GSL} -L ${LIB_MPI} -lcfitsio -lm -lgsl -lgslcblas -lmpi\n\n\n")

        file.write("SRCDIR =./\n")
        file.write("BINDIR =./\n")
        file.write("OBJDIR =./obj\n")

        file.write("# Funzione ricorsiva per cercare file sorgenti in tutte le directory\n")
        file.write("find_sources = $(wildcard $1/*.c)\n")

        file.write("dirs := $(wildcard $(SRCDIR)*/)\n\n")

        file.write("#Trova tutti i file sorgenti in tutte le directory\n")
        file.write("SOURCES := $(foreach dir, $(dirs),$(call find_sources, $(dir)))\n\n")

        file.write("#Genera i file oggetto corrispondenti ai file sorgenti\n")

        file.write("OBJECTS = $(patsubst %.c, %.o, $(SOURCES))\n\n")

        file.write("#Executable name\n")
        file.write("EXECUTABLE = $(BINDIR)/start_iteration\n\n\n")

        file.write("#Default rule: compile executable\n")
        file.write("all: $(EXECUTABLE)\n\n")

        file.write("$(EXECUTABLE): $(OBJECTS)\n")
        file.write("\t${CC} $^ -o $@ ${LDFLAGS}\n\n")

        file.write("clean:\n")
        file.write("\trm -rf $(OBJDIR) $(BINDIR) $(OBJECTS)\n\n")

        # Dichiarazione di phony targets
        file.write(".PHONY: all\n")
        file.write("\tclean\n\n")

        file.write("%.o: %.c $(DEPS)\n")
        file.write("\t$(CC) -c -o  $@ $< $(CFLAGS)\n\n")

        # Crea le directory obj e bin se non esistono
        file.write("$(shell mkdir -p $(OBJDIR) $(BINDIR))\n")

        file.write("debug:\n")
        file.write("\t@echo \"SOURCES: $(SOURCES)\"\n")
        file.write("\t@echo \"OBJECTS: $(OBJECTS)\" \n\n")

    file.close()

#===========================================================
#First check if the enviroment variable is defined
#===========================================================

if 'MC_INSTDIR' not in os.environ:
    print('Warning: the enviroment variable MC_INST_DIR is not defined')
    os.sys.exit()

#===========================================================
#Define the root folder for storing the subfolders
#===========================================================

MainFolder='tarball/'

if not os.path.exists(MainFolder):
    os.makedirs(MainFolder)

#=====================================================================
#Creates the subfolder with include files and copy to it
#=====================================================================

LocalHeaders_Folder = MainFolder + "include/"
try:
    os.makedirs(LocalHeaders_Folder)
except:
    print('Failed to create folder ', LocalHeaders_Folder)
    #os.sys.exit()


MC_Headers_Folder = os.environ['MC_INSTDIR']+'/../../include/'

for filename in os.listdir(MC_Headers_Folder):

    file_path = os.path.join(MC_Headers_Folder, filename)
    try:
        shutil.copy2(file_path, LocalHeaders_Folder)
    except Exception as e:
        print(f"Error: {e}")

#===========================================================
# Open the file for reading
#===========================================================

with open(makefile, 'r') as file:
    # Read the lines of the file
    all_lines = file.readlines()

#==============================================================
#First read the local enviroment variables from the Makefile
#==============================================================

Enviroment_Variables = dict()

for line in all_lines:

    if "=" in line:

        string_value = line.split('=')
        string_left = string_value[0]
        string_right = string_value[1]

        if ".o" not in string_right and len(string_right.split(' '))==2:

            Enviroment_Variables[string_left.strip()]=string_right.strip()

for key, value in Enviroment_Variables.items():
    if 'PWD' in value:
        Enviroment_Variables[key] = os.environ['PWD']

Enviroment_Variables['MC_INSTDIR']=os.environ['MC_INSTDIR']


for key, value in Enviroment_Variables.items():

    modified_value=replace_env_variables(value=value)
    Enviroment_Variables[key]=modified_value


#=======================================
#Select lines containing "OBJ=
#==================================================

pattern = r'\${(.*?)}'

for line in all_lines:

    if "OBJ=" in line:

        string_value = line.split('=')
        string_left = string_value[0]
        string_right = string_value[1].strip()

        #print('==================================================')

        for key in Enviroment_Variables.keys():

            if key in string_left:

                #=======================================================
                #Create the subfolder
                #=======================================================

                sub_folder = MainFolder + key.lower()
                Array_SubFolders.append(key.lower())

                if not os.path.exists(sub_folder):
                    try:
                        os.makedirs(sub_folder)
                    except:
                        print('Failed to create folder ', sub_folder)
                        os.sys.exit()
                #=======================================================

                #print('Files corresponding to Enviroment Var ', key)
                object_files = string_right.split(' ')

                #=====================================================================
                #Substitute the .o extension with .c
                #=====================================================================

                #print('Destination folder ', sub_folder)
                for file_obj in object_files:

                    if len(file_obj) > 0:

                        source_file_fullpath=file_obj.replace(".o", ".c")

                        for key in Enviroment_Variables.keys():

                            if key in source_file_fullpath:

                                source_file_fullpath=source_file_fullpath.replace('${'+key+'}', Enviroment_Variables[key])

                                try:
                                    # Copy the file to the destination folder
                                    shutil.copy(source_file_fullpath, sub_folder)
                                    #print(f"File '{explicit_file_path}' copied to '{sub_folder}' successfully.")
                                except FileNotFoundError:
                                    print(f"Error: Source file '{source_file_fullpath}' not found.")
                                    os.sys.exit()
                                except PermissionError:
                                    print("Error: Permission denied. Make sure you have the necessary permissions.")
                                except Exception as e:
                                    print(f"An error occurred: {e}")


Create_Makefile(FileName=MainFolder+'Makefile')

print('\nThe source tree has been created in subfolder %s' % (MainFolder))
print('Type command tar cfv my_archive.tar  %s to create the tarball' % (MainFolder))








