import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

def read_data(file_path):
    """
    Read the data from the input file and extract X, Y, and Z values.
    Assumes the data format is X Y Z in each line.
    """
    X, Y, Z = np.loadtxt(file_path, unpack=True)
    return X, Y, Z

def plot_3d_histogram(X, Y, Z, bins_x, bins_y):
    """
    Plot a 3D histogram using bar3d with square bins.
    """
    H, xedges, yedges = np.histogram2d(X, Y, bins=[bins_x, bins_y])
    X, Y = np.meshgrid(xedges[:-1], yedges[:-1])

    # Set the widths and depths of the bars to make them square
    dx = (xedges[1] - xedges[0])
    dy = (yedges[1] - yedges[0])

    fig = plt.figure()
    ax = fig.add_subplot(111, projection='3d')

    # Flatten the arrays
    X = X.ravel()
    Y = Y.ravel()
    Z = np.zeros_like(X)
    dx = np.full_like(X, dx)
    dy = np.full_like(X, dy)

    ax.bar3d(X, Y, Z, dx, dy, H.ravel(), shade=True)
    ax.set_xlabel('X')
    ax.set_ylabel('Y')
    ax.set_zlabel('Frequency')
    ax.set_title('3D Histogram of Z(x, y)')
    plt.show()

if __name__ == "__main__":
    # Path to the input file (replace with your file path)
    file_path = 'data.txt'

    # Read data from the input file
    X, Y, Z = read_data(file_path)

    # Number of bins for X and Y axes
    bins_x = 40  # Adjust as needed
    bins_y = 40  # Adjust as needed

    # Plot the 3D histogram
    plot_3d_histogram(X, Y, Z, bins_x, bins_y)
