#include "iteration_functions.h"

void read_iterationresults(char* filename, radiation_field_t* radiation_field)
{
  FILE* txt;
  char line[NDIM];
  int32_t tot_lines, count = 0;

  /* int ii; */

  txt = fopen(filename, "r");

  if (txt == NULL)
  {
    printf("\nWARNING\n");
    printf("Routine read_phdensity in file %s\n ", __FILE__);
    printf("File %s not found\n\n", filename);
    exit(1);
  }

  tot_lines = 0;

  while (!feof(txt))
  {
    if (fgets(line, NDIM, txt) == NULL)
    {
      break;
    }
    else if (strstr(line, "#") != NULL)
    {
      continue;
    }
    else if (strstr(line, "!") != NULL)
    {
      continue;
    }
    else
    {
      tot_lines++;
    }
  }

  rewind(txt);

  /*===================================================================*/
  /*Set pointer to structure defined in header file functions.h*/
  /*===================================================================*/

  radiation_field->u = (double*)malloc(tot_lines * sizeof(double));
  radiation_field->pdeg = (double*)malloc(tot_lines * sizeof(double));
  radiation_field->limbdark = (double*)malloc(tot_lines * sizeof(double));

  count = 0;

  while (!feof(txt))
  {
    if (fgets(line, NDIM, txt) == NULL)

      break;

    else if (strstr(line, "#") != NULL)
    {
      continue;
    }
    else if (strstr(line, "!") != NULL)
    {
      continue;
    }

    else
    {
      sscanf(line, "%lg %lg %lg\n", &radiation_field->u[count], &radiation_field->pdeg[count],
             &radiation_field->limbdark[count]);

      printf("Angle %lf  Pdeg %lf I(u) %5.4e\n", radiation_field->u[count],
             radiation_field->pdeg[count], radiation_field->limbdark[count]);

      count++;
    }
  }

  radiation_field->nlines = count;
}
